/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.verification.expectations;

import com.tidal.wave.command.Executor;
import com.tidal.wave.commands.FindTextData;
import com.tidal.wave.data.WaitTime;
import com.tidal.wave.data.WaitTimeData;
import com.tidal.wave.exceptions.TimeoutException;
import com.tidal.wave.supplier.ObjectSupplier;
import com.tidal.wave.verification.expectations.Expectation;
import com.tidal.wave.wait.FluentWait;
import java.time.Duration;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;

public class ExactTextExpectation
extends Expectation {
    private static final String FIND_TEXT_DATA = "findTextData";
    private final String value;
    private final Executor executor = (Executor)ObjectSupplier.instanceOf(Executor.class);
    private boolean isMultiple;
    private boolean isVisible;
    private List<By> locators;

    public ExactTextExpectation(String value) {
        this.value = value;
    }

    @Override
    public void assertion(boolean isVisible, boolean isMultiple, List<By> locators) {
        this.isMultiple = isMultiple;
        this.isVisible = isVisible;
        this.locators = locators;
        String duration = WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME);
        Duration waitDuration = Duration.ofSeconds(Integer.parseInt(duration));
        this.result = new FluentWait<Executor>(this.executor).pollingEvery(Duration.ofMillis(500L)).forDuration(waitDuration).ignoring(TimeoutException.class).ignoring(StaleElementReferenceException.class).withMessage(String.format("Expected value '%s' is not equal to actual value %s", this.value, this.executor.isVisible(isVisible).withMultipleElements(isMultiple).usingLocator(locators).invokeCommand(FindTextData.class, FIND_TEXT_DATA))).until(e -> e.withMultipleElements(isMultiple).isVisible(isVisible).usingLocator(locators).invokeCommand(FindTextData.class, FIND_TEXT_DATA).equals(this.value));
    }

    @Override
    public void orElseFail() {
        super.orElseFail(String.format("Expected value '%s' is not equal to actual value %s", this.value, this.executor.isVisible(this.isVisible).withMultipleElements(this.isMultiple).usingLocator(this.locators).invokeCommand(FindTextData.class, FIND_TEXT_DATA)));
    }
}

