/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.wait;

import com.tidal.wave.exceptions.RuntimeTestException;
import com.tidal.wave.exceptions.TimeoutException;
import com.tidal.wave.loggers.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.support.ui.Sleeper;

public class FluentWait<T> {
    private final Logger logger = new Logger(FluentWait.class);
    private final T input;
    private final Sleeper sleeper;
    private final List<Class<? extends Throwable>> ignoredExceptions = new ArrayList<Class<? extends Throwable>>();
    private Duration duration;
    private Duration pollingInterval;
    private Supplier<String> messageSupplier = () -> null;
    private Class<? extends Throwable> throwingException = TimeoutException.class;

    public FluentWait(T input) {
        this.input = input;
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
    }

    public FluentWait<T> withMessage(String message) {
        this.messageSupplier = () -> message;
        return this;
    }

    public FluentWait<T> withMessage(Supplier<String> messageSupplier) {
        this.messageSupplier = messageSupplier;
        return this;
    }

    public FluentWait<T> forDuration(Duration timeDuration) {
        this.duration = timeDuration;
        return this;
    }

    public FluentWait<T> pollingEvery(Duration pollingInterval) {
        this.pollingInterval = pollingInterval;
        return this;
    }

    public <K extends Throwable> FluentWait<T> ignoreAll(Collection<Class<? extends K>> types) {
        this.ignoredExceptions.addAll(types);
        return this;
    }

    public FluentWait<T> ignoring(Class<? extends Throwable> exceptionType) {
        this.ignoredExceptions.add(exceptionType);
        return this;
    }

    public FluentWait<T> throwing(Class<? extends Throwable> throwingType) {
        this.throwingException = throwingType;
        return this;
    }

    public <V> V until(Function<? super T, V> isTrue) {
        Duration timeout = this.duration;
        Duration interval = this.pollingInterval;
        Clock clock = Clock.systemDefaultZone();
        Instant end = clock.instant().plus(timeout);
        while (true) {
            Throwable lastException;
            try {
                V value = isTrue.apply(this.input);
                if (value != null && Boolean.class != value.getClass() || Boolean.TRUE.equals(value)) {
                    return value;
                }
                lastException = null;
            }
            catch (Exception e) {
                lastException = this.propagateIfNotIgnored(e);
            }
            if (end.isBefore(clock.instant())) {
                String message = this.messageSupplier != null ? this.messageSupplier.get() : null;
                String timeOutMessage = String.format("Expected condition failed: %s (tried for %d second(s) with %d milliseconds interval)", message == null ? "waiting for " + isTrue : message, timeout.getSeconds(), interval.toMillis());
                Object ex = null;
                try {
                    Constructor<? extends Throwable> constructor = this.throwingException.getConstructor(String.class, Throwable.class);
                    ex = (RuntimeException)constructor.newInstance(timeOutMessage, lastException);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    this.logger.error(e.getMessage());
                }
                if (ex != null) {
                    if (!this.ignoredExceptions.isEmpty() && this.ignoredExceptions.get(0).getName().equals(ex.getClass().getName())) {
                        this.logger.warn(timeOutMessage);
                        return isTrue.apply(this.input);
                    }
                    throw ex;
                }
                throw new TimeoutException(timeOutMessage);
            }
            try {
                this.sleeper.sleep(interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeTestException(e);
            }
        }
    }

    private Throwable propagateIfNotIgnored(Throwable e) {
        for (Class<? extends Throwable> exception : this.ignoredExceptions) {
            if (!exception.isInstance(e)) continue;
            return e;
        }
        throw new RuntimeTestException(e);
    }
}

