/*
 * Decompiled with CFR 0.152.
 */
package com.tidal.wave.webelement;

import com.tidal.wave.command.CommandContext;
import com.tidal.wave.counter.TimeCounter;
import com.tidal.wave.data.WaitTime;
import com.tidal.wave.data.WaitTimeData;
import com.tidal.wave.exceptions.ContextException;
import com.tidal.wave.wait.ThreadSleep;
import com.tidal.wave.webelement.FindWebElement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Element {
    private static final Logger logger = LoggerFactory.getLogger(Element.class);
    private TimeCounter timeCounter;

    public static WebElement element(By byLocator) {
        return Element.element(byLocator, true);
    }

    public static WebElement element(By byLocator, boolean value) {
        return new FindWebElement().webElement(byLocator, value);
    }

    public WebElement getElement(CommandContext context) {
        WebElement element;
        int duration = Integer.parseInt(WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME) == null ? WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME) : WaitTimeData.getWaitTime(WaitTime.EXPLICIT_WAIT_TIME));
        if (this.timeCounter == null) {
            this.timeCounter = new TimeCounter();
        }
        try {
            element = this.getWebElement(context);
            if (!this.timeCounter.timeElapsed(Duration.ofSeconds(duration)) && this.movementDetected(element)) {
                logger.info("Element not stable, movement detected, retrying to find the element");
                element = this.getElement(context);
            }
            this.timeCounter = null;
        }
        catch (WebDriverException e) {
            logger.error(e.getMessage());
            ThreadSleep.forMilliS(500L);
            if (this.timeCounter.timeElapsed(Duration.ofSeconds(duration))) {
                throw e;
            }
            element = this.getElement(context);
        }
        return element;
    }

    private boolean movementDetected(WebElement element) {
        Point one = element.getLocation();
        ThreadSleep.forMilliS(100L);
        Point two = element.getLocation();
        int xCordDiff = one.getX() - two.getX();
        int yCordDiff = one.getY() - two.getY();
        return xCordDiff != 0 || yCordDiff != 0;
    }

    private WebElement getWebElement(CommandContext context) {
        WebElement element;
        List<By> locators = context.getLocators();
        boolean visibility = context.getVisibility();
        boolean isMultiple = context.isMultiple();
        if (locators.size() > 1) {
            element = this.getWebElementFromSet(context);
        } else if (isMultiple) {
            element = new FindWebElement().webElements(locators.get(0), context.getElementIndex(), visibility);
        } else if (locators.size() == 1) {
            element = new FindWebElement().webElement(locators.get(0), visibility);
        } else {
            throw new ContextException("Locator(s) not set. Set locator context with appropriate function");
        }
        return element;
    }

    private WebElement getWebElementFromSet(CommandContext context) {
        List<By> locators = context.getLocators();
        boolean visibility = context.getVisibility();
        boolean isMultiple = context.isMultiple();
        WebElement element = new FindWebElement().webElement(locators.get(0), visibility);
        for (int i = 1; i < locators.size() - 1; ++i) {
            element = element.findElement(locators.get(i));
        }
        element = isMultiple ? (WebElement)element.findElements(locators.get(locators.size() - 1)).get(context.getElementIndex()) : element.findElement(locators.get(locators.size() - 1));
        return element;
    }

    public List<WebElement> getElements(CommandContext context) {
        List elements;
        List<By> locatorSet = context.getLocators();
        boolean visibility = context.getVisibility();
        int duration = Integer.parseInt(WaitTimeData.getWaitTime(WaitTime.DEFAULT_WAIT_TIME));
        if (this.timeCounter == null) {
            this.timeCounter = new TimeCounter();
        }
        try {
            if (locatorSet.size() > 1) {
                ArrayList<By> locators = new ArrayList<By>(locatorSet);
                WebElement element = new FindWebElement().webElement((By)locators.get(0), visibility);
                for (int i = 1; i < locators.size() - 1; ++i) {
                    element = element.findElement((By)locators.get(i));
                }
                elements = element.findElements((By)locators.get(locators.size() - 1));
            } else {
                elements = new FindWebElement().webElements(locatorSet.get(0), visibility);
            }
        }
        catch (WebDriverException e) {
            logger.error(e.getMessage());
            ThreadSleep.forMilliS(500L);
            if (this.timeCounter.timeElapsed(Duration.ofSeconds(duration))) {
                throw e;
            }
            elements = this.getElements(context);
        }
        this.timeCounter = null;
        return elements;
    }
}

