/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java;

import io.github.torand.openapi2java.Options;
import io.github.torand.openapi2java.collectors.ComponentResolver;
import io.github.torand.openapi2java.collectors.ResourceInfoCollector;
import io.github.torand.openapi2java.model.ResourceInfo;
import io.github.torand.openapi2java.utils.CollectionHelper;
import io.github.torand.openapi2java.utils.StringHelper;
import io.github.torand.openapi2java.writers.ResourceWriter;
import io.github.torand.openapi2java.writers.WriterFactory;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ResourceGenerator.class);
    private final Options opts;

    public ResourceGenerator(Options opts) {
        this.opts = opts;
    }

    public void generate(OpenAPI openApiDoc) {
        ComponentResolver componentResolver = new ComponentResolver(openApiDoc);
        ResourceInfoCollector resourceInfoCollector = new ResourceInfoCollector(componentResolver, this.opts);
        AtomicInteger clientCount = new AtomicInteger(0);
        openApiDoc.getTags().forEach(tag -> {
            if (CollectionHelper.isEmpty(this.opts.includeTags) || this.opts.includeTags.contains(tag.getName())) {
                clientCount.incrementAndGet();
                String resourceName = this.getResourceClassName((Tag)tag);
                if (this.opts.verbose) {
                    logger.info("Generating REST client for tag \"{}\": {}", (Object)tag.getName(), (Object)(resourceName + this.opts.resourceNameSuffix));
                }
                ResourceInfo resourceInfo = resourceInfoCollector.getResourceInfo(resourceName, (Map<String, PathItem>)openApiDoc.getPaths(), openApiDoc.getSecurity(), (Tag)tag);
                String resourceFilename = resourceInfo.name + this.opts.getFileExtension();
                try (ResourceWriter resourceWriter = WriterFactory.createResourceWriter(resourceFilename, this.opts);){
                    if (resourceInfo.isEmpty()) {
                        logger.warn("No paths found for tag \"{}\"", (Object)tag.getName());
                    } else {
                        resourceWriter.write(resourceInfo);
                    }
                }
                catch (IOException e) {
                    logger.error("Failed to write file {}", (Object)resourceFilename, (Object)e);
                }
            }
        });
        logger.info("Generated {} REST client{} in directory {}", new Object[]{clientCount.get(), StringHelper.pluralSuffix(clientCount.get()), this.opts.outputDir});
    }

    private String getResourceClassName(Tag tag) {
        String tagName = tag.getName().trim();
        String[] tagSubNames = tagName.split(" ");
        return Stream.of(tagSubNames).map(StringHelper::capitalize).collect(Collectors.joining());
    }
}

