/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.Options;
import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.Extensions;
import io.github.torand.openapi2java.collectors.PropertyInfoCollector;
import io.github.torand.openapi2java.collectors.SchemaResolver;
import io.github.torand.openapi2java.model.PojoInfo;
import io.github.torand.openapi2java.model.PropertyInfo;
import io.github.torand.openapi2java.utils.CollectionHelper;
import io.github.torand.openapi2java.utils.StringHelper;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PojoInfoCollector
extends BaseCollector {
    private final PropertyInfoCollector propertyInfoCollector;
    private final SchemaResolver schemaResolver;

    public PojoInfoCollector(SchemaResolver schemaResolver, Options opts) {
        super(opts);
        this.propertyInfoCollector = new PropertyInfoCollector(schemaResolver, opts);
        this.schemaResolver = schemaResolver;
    }

    public PojoInfo getPojoInfo(String name, Schema<?> schema) {
        PojoInfo pojoInfo = new PojoInfo();
        pojoInfo.name = name;
        Optional<String> maybeModelSubdir = Extensions.extensions(schema.getExtensions()).getString("x-model-subdir");
        pojoInfo.modelSubdir = maybeModelSubdir.orElse(null);
        pojoInfo.modelSubpackage = maybeModelSubdir.map(this::dirPath2PackagePath).orElse(null);
        if (this.opts.addMpOpenApiAnnotations) {
            pojoInfo.annotations.add(this.getSchemaAnnotation(name, schema, pojoInfo.imports));
        }
        if (Boolean.TRUE.equals(schema.getDeprecated())) {
            pojoInfo.deprecationMessage = this.formatDeprecationMessage(schema.getExtensions());
        }
        pojoInfo.properties = this.getSchemaProperties(schema);
        return pojoInfo;
    }

    private String getSchemaAnnotation(String name, Schema<?> pojo, Set<String> imports) {
        String description = pojo.getDescription();
        imports.add("org.eclipse.microprofile.openapi.annotations.media.Schema");
        ArrayList<String> schemaParams = new ArrayList<String>();
        schemaParams.add("name = \"%s\"".formatted(this.modelName2SchemaName(name)));
        schemaParams.add("description = \"%s\"".formatted(this.normalizeDescription(description)));
        if (Boolean.TRUE.equals(pojo.getDeprecated())) {
            schemaParams.add("deprecated = true");
        }
        return "@Schema(%s)".formatted(StringHelper.joinCsv(schemaParams));
    }

    private List<PropertyInfo> getSchemaProperties(Schema<?> schema) {
        ArrayList<PropertyInfo> props = new ArrayList<PropertyInfo>();
        if (CollectionHelper.nonEmpty(schema.getAllOf())) {
            schema.getAllOf().forEach(subSchema -> props.addAll(this.getSchemaProperties((Schema<?>)subSchema)));
        } else {
            if (StringHelper.nonBlank(schema.get$ref())) {
                Schema $refSchema = this.schemaResolver.getOrThrow(schema.get$ref());
                return this.getSchemaProperties($refSchema);
            }
            schema.getProperties().forEach((propName, propSchema) -> props.add(this.propertyInfoCollector.getPropertyInfo((String)propName, (Schema<?>)propSchema, this.isRequired(schema, (String)propName))));
        }
        return props;
    }

    private boolean isRequired(Schema<?> schema, String propName) {
        return CollectionHelper.nonEmpty(schema.getRequired()) && schema.getRequired().contains(propName);
    }
}

