/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.utils;

import io.github.torand.openapi2java.utils.CollectionHelper;
import java.util.List;
import java.util.Objects;

public class StringHelper {
    private StringHelper() {
    }

    public static String pluralSuffix(int count) {
        return count == 1 ? "" : "s";
    }

    public static String capitalize(String value) {
        if (StringHelper.isBlank(value)) {
            return value;
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    public static String uncapitalize(String value) {
        if (StringHelper.isBlank(value)) {
            return value;
        }
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public static String quote(String value) {
        Objects.requireNonNull(value);
        return "\"" + value + "\"";
    }

    public static List<String> quote(List<String> values) {
        Objects.requireNonNull(values);
        return values.stream().map(StringHelper::quote).toList();
    }

    public static String stripHead(String value, int count) {
        if (StringHelper.isBlank(value)) {
            return value;
        }
        return value.substring(count);
    }

    public static String stripTail(String value, int count) {
        if (StringHelper.isBlank(value)) {
            return value;
        }
        return value.substring(0, Math.max(0, value.length() - count));
    }

    public static String removeLineBreaks(String value) {
        if (StringHelper.isBlank(value)) {
            return value;
        }
        return value.replaceAll("\\n", " ");
    }

    public static String joinCsv(List<String> values) {
        if (CollectionHelper.isEmpty(values)) {
            return "";
        }
        return String.join((CharSequence)", ", values);
    }

    public static boolean isBlank(String value) {
        return Objects.isNull(value) || value.isEmpty();
    }

    public static boolean nonBlank(String value) {
        return Objects.nonNull(value) && !value.isEmpty();
    }
}

