/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.Options;
import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.Extensions;
import io.github.torand.openapi2java.collectors.SchemaResolver;
import io.github.torand.openapi2java.model.TypeInfo;
import io.github.torand.openapi2java.utils.CollectionHelper;
import io.github.torand.openapi2java.utils.Exceptions;
import io.github.torand.openapi2java.utils.StringHelper;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TypeInfoCollector
extends BaseCollector {
    private final SchemaResolver schemaResolver;

    public TypeInfoCollector(SchemaResolver schemaResolver, Options opts) {
        super(opts);
        this.schemaResolver = schemaResolver;
    }

    public <T> TypeInfo getTypeInfo(Schema<T> schema) {
        return this.getTypeInfo(schema, NullabilityResolution.FROM_SCHEMA);
    }

    public TypeInfo getTypeInfo(Schema<?> schema, NullabilityResolution nullabilityResolution) {
        if (CollectionHelper.isEmpty(schema.getTypes())) {
            boolean nullable = this.isNullable(schema, nullabilityResolution);
            if (Objects.nonNull(schema.getAnyOf())) {
                throw new IllegalStateException("Schema 'anyOf' not supported");
            }
            if (Objects.nonNull(schema.getOneOf())) {
                Schema subSchema = this.getNonNullableSubSchema(schema.getOneOf()).orElseThrow(Exceptions.illegalStateException("Schema 'oneOf' must contain a non-nullable sub-schema", new Object[0]));
                return this.getTypeInfo(subSchema, nullable ? NullabilityResolution.FORCE_NULLABLE : NullabilityResolution.FORCE_NOT_NULLABLE);
            }
            if (Objects.nonNull(schema.getAllOf()) && schema.getAllOf().size() == 1) {
                return this.getTypeInfo((Schema)schema.getAllOf().get(0), nullable ? NullabilityResolution.FORCE_NULLABLE : NullabilityResolution.FORCE_NOT_NULLABLE);
            }
            String $ref = schema.get$ref();
            if (StringHelper.nonBlank($ref)) {
                TypeInfo typeInfo;
                if (this.schemaResolver.isPrimitiveType($ref)) {
                    Schema $refSchema = this.schemaResolver.getOrThrow($ref);
                    typeInfo = this.getTypeInfo($refSchema, nullable ? NullabilityResolution.FORCE_NULLABLE : NullabilityResolution.FORCE_NOT_NULLABLE);
                } else {
                    typeInfo = new TypeInfo();
                    typeInfo.nullable = nullable;
                    typeInfo.name = this.schemaResolver.getTypeName($ref) + this.opts.pojoNameSuffix;
                    String modelSubpackage = this.schemaResolver.getModelSubpackage($ref).orElse(null);
                    typeInfo.typeImports.add(this.opts.getModelPackage(modelSubpackage) + "." + typeInfo.name);
                    if (!this.schemaResolver.isEnumType(schema.get$ref())) {
                        String validAnnotation = this.getValidAnnotation(typeInfo.annotationImports);
                        typeInfo.annotations.add(validAnnotation);
                    }
                    if (!nullable) {
                        String notNullAnnotation = this.getNotNullAnnotation(typeInfo.annotationImports);
                        typeInfo.annotations.add(notNullAnnotation);
                    }
                }
                if (StringHelper.nonBlank(schema.getDescription())) {
                    typeInfo.description = schema.getDescription();
                }
                return typeInfo;
            }
            if (CollectionHelper.isEmpty(schema.getAllOf())) {
                throw new IllegalStateException("No types, no $ref: %s".formatted(schema.toString()));
            }
        }
        return this.getJsonType(schema, nullabilityResolution);
    }

    public Optional<Schema> getNonNullableSubSchema(List<Schema> subSchemas) {
        return subSchemas.stream().filter(subSchema -> !this.isNullable((Schema<?>)subSchema)).findFirst();
    }

    private TypeInfo getJsonType(Schema<?> schema, NullabilityResolution nullabilityResolution) {
        boolean nullable;
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.description = schema.getDescription();
        typeInfo.primitive = true;
        typeInfo.nullable = nullable = this.isNullable(schema, nullabilityResolution);
        String jsonType = CollectionHelper.streamSafely(schema.getTypes()).filter(t -> !"null".equals(t)).findFirst().orElseThrow(Exceptions.illegalStateException("Unexpected types: %s", schema.toString()));
        if ("string".equals(jsonType)) {
            this.populateJsonStringType(typeInfo, schema);
        } else if ("number".equals(jsonType)) {
            this.populateJsonNumberType(typeInfo, schema);
        } else if ("integer".equals(jsonType)) {
            this.populateJsonIntegerType(typeInfo, schema);
        } else if ("boolean".equals(jsonType)) {
            this.populateJsonBooleanType(typeInfo);
        } else if ("array".equals(jsonType)) {
            this.populateJsonArrayType(typeInfo, schema);
        } else if ("object".equals(jsonType) && schema.getAdditionalProperties() instanceof Schema) {
            this.populateJsonMapType(typeInfo, schema);
        } else {
            throw new IllegalStateException("Unexpected schema: %s".formatted(schema.toString()));
        }
        Extensions.extensions(schema.getExtensions()).getString("x-json-serializer").ifPresent(jsonSerializer -> {
            String jsonSerializeAnnotation = this.getJsonSerializeAnnotation((String)jsonSerializer, typeInfo.annotationImports);
            typeInfo.annotations.add(jsonSerializeAnnotation);
        });
        Extensions.extensions(schema.getExtensions()).getString("x-validation-constraint").ifPresent(validationConstraint -> {
            typeInfo.annotations.add("@%s".formatted(this.getClassNameFromFqn((String)validationConstraint)));
            typeInfo.annotationImports.add((String)validationConstraint);
        });
        return typeInfo;
    }

    private void populateJsonStringType(TypeInfo typeInfo, Schema<?> schema) {
        if ("uri".equals(schema.getFormat())) {
            typeInfo.name = "URI";
            typeInfo.schemaFormat = schema.getFormat();
            typeInfo.typeImports.add("java.net.URI");
            if (!typeInfo.nullable) {
                String notNullAnnotation = this.getNotNullAnnotation(typeInfo.annotationImports);
                typeInfo.annotations.add(notNullAnnotation);
            }
        } else if ("uuid".equals(schema.getFormat())) {
            typeInfo.name = "UUID";
            typeInfo.schemaFormat = schema.getFormat();
            typeInfo.typeImports.add("java.util.UUID");
            if (!typeInfo.nullable) {
                String notNullAnnotation = this.getNotNullAnnotation(typeInfo.annotationImports);
                typeInfo.annotations.add(notNullAnnotation);
            }
        } else if ("duration".equals(schema.getFormat())) {
            typeInfo.name = "Duration";
            typeInfo.schemaFormat = schema.getFormat();
            typeInfo.typeImports.add("java.time.Duration");
            if (!typeInfo.nullable && this.opts.addJakartaBeanValidationAnnotations) {
                String notNullAnnotation = this.getNotNullAnnotation(typeInfo.annotationImports);
                typeInfo.annotations.add(notNullAnnotation);
            }
        } else if ("date".equals(schema.getFormat())) {
            typeInfo.name = "LocalDate";
            typeInfo.schemaFormat = schema.getFormat();
            typeInfo.typeImports.add("java.time.LocalDate");
            if (!typeInfo.nullable && this.opts.addJakartaBeanValidationAnnotations) {
                String notNullAnnotation = this.getNotNullAnnotation(typeInfo.annotationImports);
                typeInfo.annotations.add(notNullAnnotation);
            }
            String jsonFormatAnnotation = this.getJsonFormatAnnotation("yyyy-MM-dd", typeInfo.annotationImports);
            typeInfo.annotations.add(jsonFormatAnnotation);
        } else if ("date-time".equals(schema.getFormat())) {
            typeInfo.name = "LocalDateTime";
            typeInfo.schemaFormat = schema.getFormat();
            typeInfo.typeImports.add("java.time.LocalDateTime");
            if (!typeInfo.nullable && this.opts.addJakartaBeanValidationAnnotations) {
                String notNullAnnotation = this.getNotNullAnnotation(typeInfo.annotationImports);
                typeInfo.annotations.add(notNullAnnotation);
            }
            String jsonFormatAnnotation = this.getJsonFormatAnnotation("yyyy-MM-dd'T'HH:mm:ss", typeInfo.annotationImports);
            typeInfo.annotations.add(jsonFormatAnnotation);
        } else if ("email".equals(schema.getFormat())) {
            typeInfo.name = "String";
            typeInfo.schemaFormat = schema.getFormat();
            if (this.opts.addJakartaBeanValidationAnnotations) {
                if (!typeInfo.nullable) {
                    String notBlankAnnotation = this.getNotBlankAnnotation(typeInfo.annotationImports);
                    typeInfo.annotations.add(notBlankAnnotation);
                }
                String emailAnnotation = this.getEmailAnnotation(typeInfo.annotationImports);
                typeInfo.annotations.add(emailAnnotation);
            }
        } else if ("binary".equals(schema.getFormat())) {
            typeInfo.name = "byte[]";
            typeInfo.schemaFormat = schema.getFormat();
            if (this.opts.addJakartaBeanValidationAnnotations) {
                if (!typeInfo.nullable) {
                    String notEmptyAnnotation = this.getNotEmptyAnnotation(typeInfo.annotationImports);
                    typeInfo.annotations.add(notEmptyAnnotation);
                }
                if (Objects.nonNull(schema.getMinItems()) || Objects.nonNull(schema.getMaxItems())) {
                    String sizeAnnotaion = this.getArraySizeAnnotation(schema, typeInfo.annotationImports);
                    typeInfo.annotations.add(sizeAnnotaion);
                }
            }
        } else {
            typeInfo.name = "String";
            typeInfo.schemaFormat = schema.getFormat();
            if (this.opts.addJakartaBeanValidationAnnotations) {
                if (!typeInfo.nullable) {
                    String notBlankAnnotation = this.getNotBlankAnnotation(typeInfo.annotationImports);
                    typeInfo.annotations.add(notBlankAnnotation);
                }
                if (StringHelper.nonBlank(schema.getPattern())) {
                    typeInfo.schemaPattern = schema.getPattern();
                    String patternAnnotation = this.getPatternAnnotation(schema, typeInfo.annotationImports);
                    typeInfo.annotations.add(patternAnnotation);
                }
                if (Objects.nonNull(schema.getMinLength()) || Objects.nonNull(schema.getMaxLength())) {
                    String sizeAnnotation = this.getStringSizeAnnotation(schema, typeInfo.annotationImports);
                    typeInfo.annotations.add(sizeAnnotation);
                }
            }
        }
    }

    private void populateJsonNumberType(TypeInfo typeInfo, Schema<?> schema) {
        if ("double".equals(schema.getFormat())) {
            typeInfo.name = "Double";
        } else if ("float".equals(schema.getFormat())) {
            typeInfo.name = "Float";
        } else {
            typeInfo.name = "BigDecimal";
            typeInfo.typeImports.add("java.math.BigDecimal");
        }
        typeInfo.schemaFormat = schema.getFormat();
        if (this.opts.addJakartaBeanValidationAnnotations) {
            if (!typeInfo.nullable) {
                String notNullAnnotation = this.getNotNullAnnotation(typeInfo.annotationImports);
                typeInfo.annotations.add(notNullAnnotation);
            }
            if ("BigDecimal".equals(typeInfo.name)) {
                if (Objects.nonNull(schema.getMinimum())) {
                    String minAnnotation = this.getMinAnnotation(schema, typeInfo.annotationImports);
                    typeInfo.annotations.add(minAnnotation);
                }
                if (Objects.nonNull(schema.getMaximum())) {
                    String maxAnnotation = this.getMaxAnnotation(schema, typeInfo.annotationImports);
                    typeInfo.annotations.add(maxAnnotation);
                }
            }
        }
    }

    private void populateJsonIntegerType(TypeInfo typeInfo, Schema<?> schema) {
        typeInfo.name = "int64".equals(schema.getFormat()) ? "Long" : "Integer";
        typeInfo.schemaFormat = schema.getFormat();
        if (this.opts.addJakartaBeanValidationAnnotations) {
            if (!typeInfo.nullable) {
                String notNullAnnotation = this.getNotNullAnnotation(typeInfo.annotationImports);
                typeInfo.annotations.add(notNullAnnotation);
            }
            if (Objects.nonNull(schema.getMinimum())) {
                String minAnnotation = this.getMinAnnotation(schema, typeInfo.annotationImports);
                typeInfo.annotations.add(minAnnotation);
            }
            if (Objects.nonNull(schema.getMaximum())) {
                String maxAnnotation = this.getMaxAnnotation(schema, typeInfo.annotationImports);
                typeInfo.annotations.add(maxAnnotation);
            }
        }
    }

    private void populateJsonBooleanType(TypeInfo typeInfo) {
        typeInfo.name = "Boolean";
        if (!typeInfo.nullable && this.opts.addJakartaBeanValidationAnnotations) {
            String notNullAnnotation = this.getNotNullAnnotation(typeInfo.annotationImports);
            typeInfo.annotations.add(notNullAnnotation);
        }
    }

    private void populateJsonArrayType(TypeInfo typeInfo, Schema<?> schema) {
        typeInfo.primitive = false;
        if (Boolean.TRUE.equals(schema.getUniqueItems())) {
            typeInfo.name = "Set";
            typeInfo.typeImports.add("java.util.Set");
        } else {
            typeInfo.name = "List";
            typeInfo.typeImports.add("java.util.List");
        }
        if (this.opts.addJakartaBeanValidationAnnotations) {
            String validAnnotation = this.getValidAnnotation(typeInfo.annotationImports);
            typeInfo.annotations.add(validAnnotation);
        }
        typeInfo.itemType = this.getTypeInfo(schema.getItems());
        typeInfo.itemType.annotations.clear();
        typeInfo.itemType.annotationImports.clear();
        if (this.opts.addJakartaBeanValidationAnnotations) {
            String itemNotNullAnnotation = this.getNotNullAnnotation(typeInfo.itemType.annotationImports);
            typeInfo.itemType.annotations.add(itemNotNullAnnotation);
            if (!typeInfo.nullable) {
                String notNullAnnotation = this.getNotNullAnnotation(typeInfo.annotationImports);
                typeInfo.annotations.add(notNullAnnotation);
            }
            if (Objects.nonNull(schema.getMinItems()) || Objects.nonNull(schema.getMaxItems())) {
                String sizeAnnotation = this.getArraySizeAnnotation(schema, typeInfo.annotationImports);
                typeInfo.annotations.add(sizeAnnotation);
            }
        }
    }

    private void populateJsonMapType(TypeInfo typeInfo, Schema<?> schema) {
        typeInfo.name = "Map";
        typeInfo.typeImports.add("java.util.Map");
        if (this.opts.addJakartaBeanValidationAnnotations) {
            String validAnnotation = this.getValidAnnotation(typeInfo.annotationImports);
            typeInfo.annotations.add(validAnnotation);
        }
        typeInfo.keyType = this.getTypeInfo((Schema)new StringSchema());
        typeInfo.itemType = this.getTypeInfo((Schema)schema.getAdditionalProperties());
        if (this.opts.addJakartaBeanValidationAnnotations) {
            if (!typeInfo.nullable) {
                String notNullAnnotation = this.getNotNullAnnotation(typeInfo.annotationImports);
                typeInfo.annotations.add(notNullAnnotation);
            }
            if (Objects.nonNull(schema.getMinItems()) || Objects.nonNull(schema.getMaxItems())) {
                String sizeAnnotation = this.getArraySizeAnnotation(schema, typeInfo.annotationImports);
                typeInfo.annotations.add(sizeAnnotation);
            }
        }
    }

    private String getClassNameFromFqn(String fqn) {
        int lastDot = fqn.lastIndexOf(".");
        if (lastDot == -1) {
            throw new IllegalStateException("Unexpected fully qualified class name: %s".formatted(fqn));
        }
        return fqn.substring(lastDot + 1);
    }

    private boolean isNullable(Schema<?> schema, NullabilityResolution resolution) {
        return switch (resolution.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.isNullable(schema);
            case 1 -> true;
            case 2 -> false;
        };
    }

    public boolean isNullable(Schema<?> schema) {
        if (CollectionHelper.isEmpty(schema.getTypes())) {
            if (CollectionHelper.nonEmpty(schema.getAllOf())) {
                return schema.getAllOf().stream().allMatch(this::isNullable);
            }
            if (CollectionHelper.nonEmpty(schema.getOneOf())) {
                return schema.getOneOf().stream().anyMatch(this::isNullable);
            }
            if (StringHelper.nonBlank(schema.get$ref())) {
                return this.isNullableByExtension(schema);
            }
            throw new IllegalStateException("No types, no $ref: %s".formatted(schema.toString()));
        }
        return schema.getTypes().contains("null") || Boolean.TRUE.equals(schema.getNullable()) || this.isNullableByExtension(schema);
    }

    private boolean isNullableByExtension(Schema<?> schema) {
        return Extensions.extensions(schema.getExtensions()).getBoolean("x-nullable").orElse(false);
    }

    private String getJsonSerializeAnnotation(String jsonSerializer, List<String> imports) {
        imports.add("com.fasterxml.jackson.databind.annotation.JsonSerialize");
        imports.add(jsonSerializer);
        return "@JsonSerialize(using = %s)".formatted(this.getJsonSerializerClass(jsonSerializer));
    }

    private String getJsonFormatAnnotation(String pattern, List<String> imports) {
        imports.add("com.fasterxml.jackson.annotation.JsonFormat");
        return "@JsonFormat(pattern = \"%s\")".formatted(pattern);
    }

    private String getValidAnnotation(List<String> imports) {
        imports.add("jakarta.validation.Valid");
        return "@Valid";
    }

    private String getNotNullAnnotation(List<String> imports) {
        imports.add("jakarta.validation.constraints.NotNull");
        return "@NotNull";
    }

    private String getNotBlankAnnotation(List<String> imports) {
        imports.add("jakarta.validation.constraints.NotBlank");
        return "@NotBlank";
    }

    private String getNotEmptyAnnotation(List<String> imports) {
        imports.add("jakarta.validation.constraints.NotEmpty");
        return "@NotEmpty";
    }

    private String getMinAnnotation(Schema<?> schema, List<String> imports) {
        imports.add("jakarta.validation.constraints.Min");
        return "@Min(%d)".formatted(schema.getMinimum().longValue());
    }

    private String getMaxAnnotation(Schema<?> schema, List<String> imports) {
        imports.add("jakarta.validation.constraints.Max");
        return "@Max(%d)".formatted(schema.getMaximum().longValue());
    }

    private String getPatternAnnotation(Schema<?> schema, List<String> imports) {
        imports.add("jakarta.validation.constraints.Pattern");
        return "@Pattern(regexp = \"%s\")".formatted(schema.getPattern());
    }

    private String getEmailAnnotation(List<String> imports) {
        imports.add("jakarta.validation.constraints.Email");
        return "@Email";
    }

    private String getArraySizeAnnotation(Schema<?> schema, List<String> imports) {
        ArrayList<String> sizeParams = new ArrayList<String>();
        if (Objects.nonNull(schema.getMinItems())) {
            sizeParams.add("min = %d".formatted(schema.getMinItems()));
        }
        if (Objects.nonNull(schema.getMaxItems())) {
            sizeParams.add("max = %d".formatted(schema.getMaxItems()));
        }
        imports.add("jakarta.validation.constraints.Size");
        return "@Size(%s)".formatted(StringHelper.joinCsv(sizeParams));
    }

    private String getStringSizeAnnotation(Schema<?> schema, List<String> imports) {
        ArrayList<String> sizeParams = new ArrayList<String>();
        if (Objects.nonNull(schema.getMinLength())) {
            sizeParams.add("min = %d".formatted(schema.getMinLength()));
        }
        if (Objects.nonNull(schema.getMaxLength())) {
            sizeParams.add("max = %d".formatted(schema.getMaxLength()));
        }
        imports.add("jakarta.validation.constraints.Size");
        return "@Size(%s)".formatted(StringHelper.joinCsv(sizeParams));
    }

    private String getJsonSerializerClass(String jsonSerializerFqn) {
        String className = this.getClassNameFromFqn(jsonSerializerFqn);
        return this.opts.useKotlinSyntax ? className + "::class" : className + ".class";
    }

    public static enum NullabilityResolution {
        FROM_SCHEMA,
        FORCE_NULLABLE,
        FORCE_NOT_NULLABLE;

    }
}

