/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.writers.kotlin;

import io.github.torand.openapi2java.Options;
import io.github.torand.openapi2java.model.EnumInfo;
import io.github.torand.openapi2java.utils.CollectionHelper;
import io.github.torand.openapi2java.utils.StringHelper;
import io.github.torand.openapi2java.writers.BaseWriter;
import io.github.torand.openapi2java.writers.EnumWriter;
import java.io.Writer;

public class KotlinEnumWriter
extends BaseWriter
implements EnumWriter {
    public KotlinEnumWriter(Writer writer, Options opts) {
        super(writer, opts);
    }

    @Override
    public void write(EnumInfo enumInfo) {
        this.writeLine("package %s", this.opts.getModelPackage(enumInfo.modelSubpackage));
        this.writeNewLine();
        if (CollectionHelper.nonEmpty(enumInfo.imports)) {
            enumInfo.imports.forEach(ti -> this.writeLine("import %s".formatted(ti), new Object[0]));
            this.writeNewLine();
        }
        enumInfo.annotations.forEach(x$0 -> this.writeLine((String)x$0, new Object[0]));
        this.writeLine("enum class %s {".formatted(enumInfo.name), new Object[0]);
        this.writeIndent(1);
        this.writeLine(StringHelper.joinCsv(enumInfo.constants), new Object[0]);
        this.writeLine("}", new Object[0]);
    }
}

