/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.Extensions;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.EnumInfo;
import io.github.torand.openapi2java.utils.StringUtils;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;

public class EnumInfoCollector
extends BaseCollector {
    public EnumInfoCollector(Options opts) {
        super(opts);
    }

    public EnumInfo getEnumInfo(String name, Schema<?> schema) {
        EnumInfo enumInfo = new EnumInfo();
        enumInfo.name = name;
        Optional<String> maybeModelSubdir = Extensions.extensions(schema.getExtensions()).getString("x-model-subdir");
        enumInfo.modelSubdir = maybeModelSubdir.orElse(null);
        enumInfo.modelSubpackage = maybeModelSubdir.map(this::dirPath2PackagePath).orElse(null);
        if (this.opts.addMpOpenApiAnnotations) {
            enumInfo.annotations.add(this.getSchemaAnnotation(name, schema, enumInfo.imports));
        }
        if (Boolean.TRUE.equals(schema.getDeprecated())) {
            enumInfo.annotations.add("@Deprecated");
        }
        enumInfo.constants.addAll(schema.getEnum());
        return enumInfo;
    }

    private String getSchemaAnnotation(String name, Schema<?> pojo, Set<String> imports) {
        String description = pojo.getDescription();
        imports.add("org.eclipse.microprofile.openapi.annotations.media.Schema");
        ArrayList<String> schemaParams = new ArrayList<String>();
        schemaParams.add("name = \"%s\"".formatted(this.modelName2SchemaName(name)));
        schemaParams.add("description = \"%s\"".formatted(this.normalizeDescription(description)));
        if (Boolean.TRUE.equals(pojo.getDeprecated())) {
            schemaParams.add("deprecated = true");
        }
        return "@Schema(%s)".formatted(StringUtils.joinCsv(schemaParams));
    }
}

