/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.ComponentResolver;
import io.github.torand.openapi2java.collectors.Extensions;
import io.github.torand.openapi2java.collectors.MethodInfoCollector;
import io.github.torand.openapi2java.collectors.SecurityRequirementCollector;
import io.github.torand.openapi2java.collectors.TypeInfoCollector;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.MethodInfo;
import io.github.torand.openapi2java.model.ResourceInfo;
import io.github.torand.openapi2java.model.SecurityRequirementInfo;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ResourceInfoCollector
extends BaseCollector {
    public static final String AUTH_METHOD_NAME = "authorization";
    private final MethodInfoCollector methodInfoCollector;
    private final SecurityRequirementCollector securityRequirementCollector;

    public ResourceInfoCollector(ComponentResolver componentResolver, Options opts) {
        super(opts);
        TypeInfoCollector typeInfoCollector = new TypeInfoCollector(componentResolver.schemas(), opts);
        this.methodInfoCollector = new MethodInfoCollector(componentResolver, typeInfoCollector, opts);
        this.securityRequirementCollector = new SecurityRequirementCollector(opts);
    }

    public ResourceInfo getResourceInfo(String resourceName, Map<String, PathItem> paths, List<SecurityRequirement> securityRequirements, Tag tag) {
        ResourceInfo resourceInfo = new ResourceInfo();
        resourceInfo.name = resourceName + this.opts.resourceNameSuffix;
        if (this.opts.useResteasyResponse) {
            resourceInfo.imports.add("org.jboss.resteasy.reactive.RestResponse");
        } else {
            resourceInfo.imports.add("jakarta.ws.rs.core.Response");
        }
        if (CollectionHelper.nonEmpty(securityRequirements)) {
            SecurityRequirementInfo secReqInfo = this.securityRequirementCollector.getSequrityRequirementInfo(securityRequirements);
            resourceInfo.imports.addAll(secReqInfo.imports);
            resourceInfo.annotations.addAll(secReqInfo.annotations);
        }
        if (this.opts.addMpOpenApiAnnotations && Objects.nonNull(tag)) {
            resourceInfo.imports.add("org.eclipse.microprofile.openapi.annotations.tags.Tag");
            resourceInfo.annotations.add("@Tag(name = \"%s\", description = \"%s\")".formatted(tag.getName(), this.normalizeDescription(tag.getDescription())));
        }
        if (this.opts.addMpRestClientAnnotations) {
            String configKey = Objects.nonNull(tag) ? Extensions.extensions(tag.getExtensions()).getString("x-restclient-configkey").orElse(tag.getName().toLowerCase() + "-api") : resourceName.toLowerCase() + "-api";
            resourceInfo.imports.add("org.eclipse.microprofile.rest.client.inject.RegisterRestClient");
            resourceInfo.annotations.add("@RegisterRestClient(configKey = \"%s\")".formatted(configKey));
            resourceInfo.imports.add("org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam");
            resourceInfo.staticImports.add("jakarta.ws.rs.core.HttpHeaders.AUTHORIZATION");
            resourceInfo.annotations.add("@ClientHeaderParam(name = AUTHORIZATION, value = %s)".formatted(this.formatAnnotationNamedParam(List.of("\"{%s}\"".formatted(AUTH_METHOD_NAME)))));
            resourceInfo.authMethod = this.getAuthMethodInfo();
        }
        resourceInfo.imports.add("jakarta.ws.rs.Path");
        resourceInfo.staticImports.add("%s.%s.ROOT_PATH".formatted(this.opts.rootPackage, resourceInfo.name));
        resourceInfo.annotations.add("@Path(ROOT_PATH)");
        String tagName = Objects.nonNull(tag) ? tag.getName() : null;
        paths.forEach((path, pathInfo) -> {
            if (this.shouldProcessOperation(pathInfo.getGet(), tagName)) {
                resourceInfo.methods.add(this.methodInfoCollector.getMethodInfo("GET", (String)path, pathInfo.getGet()));
            }
            if (this.shouldProcessOperation(pathInfo.getPost(), tagName)) {
                resourceInfo.methods.add(this.methodInfoCollector.getMethodInfo("POST", (String)path, pathInfo.getPost()));
            }
            if (this.shouldProcessOperation(pathInfo.getDelete(), tagName)) {
                resourceInfo.methods.add(this.methodInfoCollector.getMethodInfo("DELETE", (String)path, pathInfo.getDelete()));
            }
            if (this.shouldProcessOperation(pathInfo.getPut(), tagName)) {
                resourceInfo.methods.add(this.methodInfoCollector.getMethodInfo("PUT", (String)path, pathInfo.getPut()));
            }
            if (this.shouldProcessOperation(pathInfo.getPatch(), tagName)) {
                resourceInfo.methods.add(this.methodInfoCollector.getMethodInfo("PATCH", (String)path, pathInfo.getPatch()));
            }
        });
        return resourceInfo;
    }

    private MethodInfo getAuthMethodInfo() {
        MethodInfo authMethod = new MethodInfo();
        if (!this.opts.useKotlinSyntax) {
            authMethod.annotations.add("@SuppressWarnings(\"unused\") // Used by @ClientHeaderParam");
        }
        authMethod.name = AUTH_METHOD_NAME;
        return authMethod;
    }

    private boolean shouldProcessOperation(Operation operation, String tag) {
        if (Objects.isNull(operation)) {
            return false;
        }
        if (Objects.isNull(tag)) {
            return true;
        }
        return Objects.nonNull(operation.getTags()) && operation.getTags().contains(tag);
    }
}

