/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.generators;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.lang.Exceptions;
import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.openapi2java.collectors.ComponentResolver;
import io.github.torand.openapi2java.collectors.EnumInfoCollector;
import io.github.torand.openapi2java.collectors.PojoInfoCollector;
import io.github.torand.openapi2java.collectors.SchemaResolver;
import io.github.torand.openapi2java.collectors.TypeInfoCollector;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.EnumInfo;
import io.github.torand.openapi2java.model.PojoInfo;
import io.github.torand.openapi2java.model.TypeInfo;
import io.github.torand.openapi2java.utils.StringUtils;
import io.github.torand.openapi2java.writers.EnumWriter;
import io.github.torand.openapi2java.writers.PojoWriter;
import io.github.torand.openapi2java.writers.WriterFactory;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ModelGenerator.class);
    private final Options opts;

    public ModelGenerator(Options opts) {
        this.opts = opts;
    }

    public void generate(OpenAPI openApiDoc) {
        ComponentResolver componentResolver = new ComponentResolver(openApiDoc);
        Set<String> relevantPojos = this.getRelevantPojos(openApiDoc, componentResolver);
        AtomicInteger enumCount = new AtomicInteger(0);
        AtomicInteger pojoCount = new AtomicInteger(0);
        openApiDoc.getComponents().getSchemas().forEach((name, schema) -> {
            String pojoName = name + this.opts.pojoNameSuffix;
            if (relevantPojos.contains(pojoName)) {
                if (this.isEnum((Schema<?>)schema)) {
                    this.generateEnumFile(pojoName, (Schema<?>)schema);
                    enumCount.incrementAndGet();
                }
                if (this.isClass((Schema<?>)schema)) {
                    this.generatePojoFile(pojoName, (Schema<?>)schema, componentResolver.schemas());
                    pojoCount.incrementAndGet();
                }
            }
        });
        logger.info("Generated {} enum{}, {} pojo{} in directory {}", new Object[]{enumCount.get(), StringUtils.pluralSuffix(enumCount.get()), pojoCount.get(), StringUtils.pluralSuffix(pojoCount.get()), this.opts.getModelOutputDir(null)});
    }

    private void generateEnumFile(String name, Schema<?> schema) {
        if (this.opts.verbose) {
            logger.info("Generating model enum {}", (Object)name);
        }
        EnumInfoCollector enumInfoCollector = new EnumInfoCollector(this.opts);
        EnumInfo enumInfo = enumInfoCollector.getEnumInfo(name, schema);
        String enumFilename = name + this.opts.getFileExtension();
        try (EnumWriter enumWriter = WriterFactory.createEnumWriter(enumFilename, this.opts, enumInfo.modelSubdir);){
            enumWriter.write(enumInfo);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write file %s".formatted(enumFilename), e);
        }
    }

    private void generatePojoFile(String name, Schema<?> schema, SchemaResolver schemaResolver) {
        if (this.opts.verbose) {
            logger.info("Generating model class {}", (Object)name);
        }
        PojoInfoCollector pojoInfoCollector = new PojoInfoCollector(schemaResolver, this.opts);
        PojoInfo pojoInfo = pojoInfoCollector.getPojoInfo(name, schema);
        String pojoFilename = name + this.opts.getFileExtension();
        try (PojoWriter pojoWriter = WriterFactory.createPojoWriter(pojoFilename, this.opts, pojoInfo.modelSubdir);){
            pojoWriter.write(pojoInfo);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write file %s".formatted(pojoFilename), e);
        }
    }

    private Set<String> getRelevantPojos(OpenAPI openApiDoc, ComponentResolver componentResolver) {
        record PathOperation(String path, String method, Operation operation) {
        }
        return openApiDoc.getPaths().entrySet().stream().flatMap(entry -> {
            String path = (String)entry.getKey();
            PathItem pathItem = (PathItem)entry.getValue();
            return Stream.of(new PathOperation(path, "GET", pathItem.getGet()), new PathOperation(path, "PUT", pathItem.getPut()), new PathOperation(path, "POST", pathItem.getPost()), new PathOperation(path, "DELETE", pathItem.getDelete()), new PathOperation(path, "PATCH", pathItem.getPatch())).filter(po -> po.operation != null);
        }).map(pathOperation -> {
            try {
                if (this.opts.verbose) {
                    logger.info("Getting relevant Pojos for {} {}", (Object)pathOperation.method, (Object)pathOperation.path);
                }
                return this.getRelevantPojosForOperation(pathOperation.operation(), componentResolver);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Failed to get relevant Pojos for %s %s".formatted(pathOperation.method, pathOperation.path), e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<String> getRelevantPojosForOperation(Operation operation, ComponentResolver componentResolver) {
        TypeInfoCollector typeInfoCollector = new TypeInfoCollector(componentResolver.schemas(), this.opts);
        HashSet<String> relevantPojos = new HashSet<String>();
        if (CollectionHelper.isEmpty((Collection)operation.getTags()) || this.isRelevantTag(operation)) {
            if (CollectionHelper.nonEmpty((Collection)operation.getParameters())) {
                operation.getParameters().forEach(parameter -> {
                    Parameter realParameter = parameter;
                    if (StringHelper.nonBlank((String)parameter.get$ref())) {
                        realParameter = componentResolver.parameters().getOrThrow(parameter.get$ref());
                    }
                    if (Objects.nonNull(realParameter.getSchema())) {
                        this.getPojoTypeName(realParameter.getSchema(), typeInfoCollector).ifPresent(relevantPojos::add);
                    }
                    if (CollectionHelper.nonEmpty((Map)realParameter.getContent())) {
                        realParameter.getContent().forEach((contentType, mediaType) -> {
                            if (Objects.nonNull(mediaType.getSchema())) {
                                this.getPojoTypeName(mediaType.getSchema(), typeInfoCollector).ifPresent(relevantPojos::add);
                            }
                        });
                    }
                });
            }
            if (Objects.nonNull(operation.getRequestBody()) && CollectionHelper.nonEmpty((Map)operation.getRequestBody().getContent())) {
                operation.getRequestBody().getContent().forEach((contentType, mediaType) -> {
                    if (Objects.nonNull(mediaType.getSchema())) {
                        this.getPojoTypeName(mediaType.getSchema(), typeInfoCollector).ifPresent(relevantPojos::add);
                    }
                });
            }
            if (CollectionHelper.nonEmpty((Map)operation.getResponses())) {
                operation.getResponses().forEach((code, response) -> {
                    ApiResponse realResponse = response;
                    if (StringHelper.nonBlank((String)response.get$ref())) {
                        realResponse = componentResolver.responses().getOrThrow(response.get$ref());
                    }
                    if (CollectionHelper.nonEmpty((Map)realResponse.getContent())) {
                        realResponse.getContent().forEach((contentType, mediaType) -> {
                            if (Objects.nonNull(mediaType.getSchema())) {
                                this.getPojoTypeName(mediaType.getSchema(), typeInfoCollector).ifPresent(relevantPojos::add);
                            }
                        });
                    }
                });
            }
        }
        relevantPojos.addAll(this.getNestedPojos(relevantPojos, componentResolver.schemas()));
        return relevantPojos;
    }

    private Set<String> getNestedPojos(Set<String> parentPojos, SchemaResolver schemaResolver) {
        TypeInfoCollector typeInfoCollector = new TypeInfoCollector(schemaResolver, this.opts);
        HashSet<String> nestedPojos = new HashSet<String>();
        parentPojos.forEach(pojo -> {
            String schemaRef = "#/components/schemas/" + StringHelper.stripTail((String)pojo, (int)this.opts.pojoNameSuffix.length());
            schemaResolver.get(schemaRef).ifPresent(schema -> nestedPojos.addAll(this.getNestedSchemaTypes((Schema<?>)schema, schemaResolver, typeInfoCollector)));
        });
        return nestedPojos;
    }

    private Set<String> getNestedSchemaTypes(Schema<?> parentSchema, SchemaResolver schemaResolver, TypeInfoCollector typeInfoCollector) {
        HashSet<String> schemaTypes = new HashSet<String>();
        if (CollectionHelper.nonEmpty((Collection)parentSchema.getAllOf())) {
            parentSchema.getAllOf().forEach(subSchema -> schemaTypes.addAll(this.getNestedSchemaTypes((Schema<?>)subSchema, schemaResolver, typeInfoCollector)));
        } else if (CollectionHelper.nonEmpty((Collection)parentSchema.getOneOf())) {
            Schema subSchema2 = typeInfoCollector.getNonNullableSubSchema(parentSchema.getOneOf()).orElseThrow(Exceptions.illegalStateException((String)"Schema 'oneOf' must contain a non-nullable sub-schema", (Object[])new Object[0]));
            schemaTypes.addAll(this.getNestedSchemaTypes(subSchema2, schemaResolver, typeInfoCollector));
        } else if (StringHelper.nonBlank((String)parentSchema.get$ref())) {
            this.getPojoTypeName(parentSchema, typeInfoCollector).ifPresent(schemaTypes::add);
            Schema $refSchema = schemaResolver.getOrThrow(parentSchema.get$ref());
            schemaTypes.addAll(this.getNestedSchemaTypes($refSchema, schemaResolver, typeInfoCollector));
        } else if (CollectionHelper.nonEmpty((Map)parentSchema.getProperties())) {
            parentSchema.getProperties().forEach((propName, propSchema) -> schemaTypes.addAll(this.getNestedSchemaTypes((Schema<?>)propSchema, schemaResolver, typeInfoCollector)));
        } else if (Objects.nonNull(parentSchema.getItems())) {
            schemaTypes.addAll(this.getNestedSchemaTypes(parentSchema.getItems(), schemaResolver, typeInfoCollector));
        }
        return schemaTypes;
    }

    private Optional<String> getPojoTypeName(Schema<?> schema, TypeInfoCollector typeInfoCollector) {
        if (SchemaResolver.isObjectType(schema)) {
            return Optional.empty();
        }
        TypeInfo bodyType = typeInfoCollector.getTypeInfo(schema);
        if (Objects.nonNull(bodyType.itemType)) {
            return Optional.of(bodyType.itemType.name);
        }
        return Optional.of(bodyType.name);
    }

    private boolean isRelevantTag(Operation operation) {
        return CollectionHelper.isEmpty(this.opts.includeTags) || CollectionHelper.streamSafely((Iterable)operation.getTags()).anyMatch(tag -> this.opts.includeTags.contains(tag));
    }

    private boolean isEnum(Schema<?> schema) {
        return CollectionHelper.streamSafely((Iterable)schema.getTypes()).anyMatch("string"::equals) && Objects.nonNull(schema.getEnum());
    }

    private boolean isClass(Schema<?> schema) {
        return CollectionHelper.streamSafely((Iterable)schema.getTypes()).anyMatch("object"::equals) || Objects.nonNull(schema.getAllOf());
    }
}

