/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java;

import io.github.torand.openapi2java.generators.ModelGenerator;
import io.github.torand.openapi2java.generators.OpenApiDefGenerator;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.generators.ResourceGenerator;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class OpenApi2JavaMojo
extends AbstractMojo {
    private static final Logger logger = LoggerFactory.getLogger(OpenApi2JavaMojo.class);
    @Parameter(property="openApiFile", required=true)
    private String openApiFile;
    @Parameter(property="outputDir", defaultValue="${project.build.directory}")
    private String outputDir;
    @Parameter(property="rootPackage", required=true)
    private String rootPackage;
    @Parameter(property="rootUrlPath", defaultValue="api")
    private String rootUrlPath;
    @Parameter(property="resourceNameSuffix", defaultValue="Api")
    private String resourceNameSuffix;
    @Parameter(property="resourceNameOverride", defaultValue="")
    private String resourceNameOverride;
    @Parameter(property="resourceConfigKeyOverride", defaultValue="")
    private String resourceConfigKeyOverride;
    @Parameter(property="resourceClientHeadersFactoryOverride", defaultValue="")
    private String resourceClientHeadersFactoryOverride;
    @Parameter(property="resourceProvidersOverride", defaultValue="")
    private List<String> resourceProvidersOverride;
    @Parameter(property="pojoNameSuffix", defaultValue="Dto")
    private String pojoNameSuffix;
    @Parameter(property="pojosAsRecords", defaultValue="true")
    private boolean pojosAsRecords;
    @Parameter(property="includeTags", defaultValue="")
    private List<String> includeTags;
    @Parameter(property="generateResourceInterfaces", defaultValue="true")
    private boolean generateResourceInterfaces;
    @Parameter(property="generateOpenApiDefClass", defaultValue="true")
    private boolean generateOpenApiDefClass;
    @Parameter(property="addJsonPropertyAnnotations", defaultValue="true")
    private boolean addJsonPropertyAnnotations;
    @Parameter(property="addJakartaBeanValidationAnnotations", defaultValue="true")
    private boolean addJakartaBeanValidationAnnotations;
    @Parameter(property="addMpOpenApiAnnotations", defaultValue="true")
    private boolean addMpOpenApiAnnotations;
    @Parameter(property="addMpRestClientAnnotations", defaultValue="true")
    private boolean addMpRestClientAnnotations;
    @Parameter(property="useKotlinSyntax", defaultValue="false")
    private boolean useKotlinSyntax;
    @Parameter(property="useResteasyResponse", defaultValue="false")
    private boolean useResteasyResponse;
    @Parameter(property="useOidcClientAnnotation", defaultValue="false")
    private boolean useOidcClientAnnotation;
    @Parameter(property="indentWithTab", defaultValue="false")
    private boolean indentWithTab;
    @Parameter(property="indentSize", defaultValue="4")
    private int indentSize;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;

    public void execute() throws MojoExecutionException {
        SwaggerParseResult result = new OpenAPIV3Parser().readLocation(this.openApiFile, null, null);
        OpenAPI openApiDoc = result.getOpenAPI();
        Options opts = new Options(this.outputDir, this.rootPackage, this.rootUrlPath, this.resourceNameSuffix, this.resourceNameOverride, this.resourceConfigKeyOverride, this.resourceClientHeadersFactoryOverride, this.resourceProvidersOverride, this.pojoNameSuffix, this.pojosAsRecords, this.includeTags, this.generateResourceInterfaces, this.generateOpenApiDefClass, this.addJsonPropertyAnnotations, this.addJakartaBeanValidationAnnotations, this.addMpOpenApiAnnotations, this.addMpRestClientAnnotations, this.useKotlinSyntax, this.useResteasyResponse, this.useOidcClientAnnotation, this.indentWithTab, this.indentSize, this.verbose);
        if (this.useResteasyResponse && !this.addJsonPropertyAnnotations) {
            logger.info("Using ResteasyResponse: explicitly setting 'addJsonPropertyAnnotations' to true");
            this.addJsonPropertyAnnotations = true;
        }
        ModelGenerator modelGenerator = new ModelGenerator(opts);
        modelGenerator.generate(openApiDoc);
        if (opts.generateResourceInterfaces()) {
            ResourceGenerator resourceGenerator = new ResourceGenerator(opts);
            resourceGenerator.generate(openApiDoc);
        }
        if (opts.generateOpenApiDefClass()) {
            OpenApiDefGenerator openApiDefGenerator = new OpenApiDefGenerator(opts);
            openApiDefGenerator.generate(openApiDoc);
        }
    }
}

