/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.openapi2java.collectors.Extensions;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.ConstantValue;
import io.github.torand.openapi2java.utils.KotlinTypeMapper;
import io.github.torand.openapi2java.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class BaseCollector {
    protected final Options opts;

    protected BaseCollector(Options opts) {
        this.opts = opts;
    }

    protected String normalizeDescription(String description) {
        return StringHelper.nonBlank((String)description) ? description.replace("%", "%%") : "TBD";
    }

    protected String normalizePath(String path) {
        if (path.startsWith("/")) {
            path = StringHelper.stripHead((String)path, (int)1);
        }
        if (path.endsWith("/")) {
            path = StringHelper.stripTail((String)path, (int)1);
        }
        return path;
    }

    protected String dirPath2PackagePath(String dirPath) {
        return dirPath.replace("/", ".");
    }

    protected String modelName2SchemaName(String modelName) {
        return modelName.replaceFirst(this.opts.pojoNameSuffix() + "$", "");
    }

    protected String formatClassRef(String className) {
        return this.opts.useKotlinSyntax() ? "%s::class".formatted(KotlinTypeMapper.toKotlinNative(className)) : "%s.class".formatted(className);
    }

    protected String formatInnerAnnotation(String annotation, Object ... args) {
        return (this.opts.useKotlinSyntax() ? "" : "@") + annotation.formatted(args);
    }

    protected String formatAnnotationDefaultParam(List<String> value) {
        if (value.size() == 1) {
            return value.get(0);
        }
        if (this.opts.useKotlinSyntax()) {
            return StringUtils.joinCsv(value);
        }
        return "{" + StringUtils.joinCsv(value) + "}";
    }

    protected String formatAnnotationNamedParam(List<String> value) {
        if (this.opts.useKotlinSyntax()) {
            return "[ " + StringUtils.joinCsv(value) + " ]";
        }
        return value.size() == 1 ? value.get(0) : "{ " + StringUtils.joinCsv(value) + " }";
    }

    protected String formatDeprecationMessage(Map<String, Object> extensionsByName) {
        return Extensions.extensions(extensionsByName).getString("x-deprecation-message").orElse("Deprecated");
    }

    protected ConstantValue getHeaderNameConstant(String name) {
        String standardHeaderConstant;
        switch (name.toUpperCase()) {
            case "ACCEPT-LANGUAGE": {
                String string = "ACCEPT_LANGUAGE";
                break;
            }
            case "AUTHORIZATION": {
                String string = "AUTHORIZATION";
                break;
            }
            case "CONTENT-LANGUAGE": {
                String string = "CONTENT_LANGUAGE";
                break;
            }
            case "LOCATION": {
                String string = "LOCATION";
                break;
            }
            default: {
                String string = standardHeaderConstant = null;
            }
        }
        if (Objects.nonNull(standardHeaderConstant)) {
            return new ConstantValue(standardHeaderConstant).withStaticImport("jakarta.ws.rs.core.HttpHeaders." + standardHeaderConstant);
        }
        return new ConstantValue(StringHelper.quote((String)name));
    }
}

