/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.Extensions;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.EnumInfo;
import io.github.torand.openapi2java.utils.StringUtils;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Optional;

public class EnumInfoCollector
extends BaseCollector {
    public EnumInfoCollector(Options opts) {
        super(opts);
    }

    public EnumInfo getEnumInfo(String name, Schema<?> schema) {
        Optional<String> maybeModelSubdir = Extensions.extensions(schema.getExtensions()).getString("x-model-subdir");
        EnumInfo enumInfo = new EnumInfo(name, schema.getEnum()).withModelSubdir(maybeModelSubdir.orElse(null)).withModelSubpackage(maybeModelSubdir.map(this::dirPath2PackagePath).orElse(null));
        if (this.opts.addMpOpenApiAnnotations()) {
            enumInfo = enumInfo.withAddedAnnotation(this.getSchemaAnnotation(name, schema));
        }
        if (Boolean.TRUE.equals(schema.getDeprecated())) {
            enumInfo = enumInfo.withAddedAnnotation(new AnnotationInfo("@Deprecated"));
        }
        return enumInfo;
    }

    private AnnotationInfo getSchemaAnnotation(String name, Schema<?> pojo) {
        String description = pojo.getDescription();
        ArrayList<String> schemaParams = new ArrayList<String>();
        schemaParams.add("name = \"%s\"".formatted(this.modelName2SchemaName(name)));
        schemaParams.add("description = \"%s\"".formatted(this.normalizeDescription(description)));
        if (Boolean.TRUE.equals(pojo.getDeprecated())) {
            schemaParams.add("deprecated = true");
        }
        return new AnnotationInfo("@Schema(%s)".formatted(StringUtils.joinCsv(schemaParams)), "org.eclipse.microprofile.openapi.annotations.media.Schema");
    }
}

