/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.openapi2java.utils.OpenApi2JavaException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Extensions {
    public static final String EXT_RESTCLIENT_CONFIGKEY = "x-restclient-configkey";
    public static final String EXT_RESTCLIENT_HEADERS = "x-restclient-headers";
    public static final String EXT_RESTCLIENT_HEADERSFACTORY = "x-restclient-headersfactory";
    public static final String EXT_RESTCLIENT_PROVIDERS = "x-restclient-providers";
    public static final String EXT_JSON_SERIALIZER = "x-json-serializer";
    public static final String EXT_VALIDATION_CONSTRAINT = "x-validation-constraint";
    public static final String EXT_NULLABLE = "x-nullable";
    public static final String EXT_MODEL_SUBDIR = "x-model-subdir";
    public static final String EXT_DEPRECATION_MESSAGE = "x-deprecation-message";
    private final Map<String, Object> extensionsByName;

    public static Extensions extensions(Map<String, Object> extensionsByName) {
        return new Extensions(extensionsByName);
    }

    private Extensions(Map<String, Object> extensionsByName) {
        this.extensionsByName = Objects.nonNull(extensionsByName) ? extensionsByName : Collections.emptyMap();
    }

    public Optional<String> getString(String name) {
        Object value = this.extensionsByName.get(name);
        if (Objects.isNull(value)) {
            return Optional.empty();
        }
        if (!(value instanceof String)) {
            throw new OpenApi2JavaException("Value of extension %s is not a String".formatted(name));
        }
        if (StringHelper.nonBlank((String)((String)value))) {
            return Optional.of((String)value);
        }
        return Optional.empty();
    }

    public Optional<List<String>> getStringArray(String name) {
        Object value = this.extensionsByName.get(name);
        if (Objects.isNull(value)) {
            return Optional.empty();
        }
        if (!(value instanceof List)) {
            throw new OpenApi2JavaException("Value of extension %s is not an array".formatted(name));
        }
        return Optional.of((List)value);
    }

    public Optional<Boolean> getBoolean(String name) {
        Object value = this.extensionsByName.get(name);
        if (Objects.isNull(value)) {
            return Optional.empty();
        }
        if (!(value instanceof Boolean)) {
            throw new OpenApi2JavaException("Value of extension %s is not a Boolean".formatted(name));
        }
        return Optional.of((Boolean)value);
    }

    public Optional<Map<String, Object>> getMap(String name) {
        Object value = this.extensionsByName.get(name);
        if (Objects.isNull(value)) {
            return Optional.empty();
        }
        if (!(value instanceof Map)) {
            throw new OpenApi2JavaException("Value of extension %s is not a Map (object)".formatted(name));
        }
        return Optional.of((Map)value);
    }
}

