/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.javacommons.stream.StreamHelper;
import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.ComponentResolver;
import io.github.torand.openapi2java.collectors.SchemaResolver;
import io.github.torand.openapi2java.collectors.SecurityRequirementCollector;
import io.github.torand.openapi2java.collectors.TypeInfoCollector;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.ConstantValue;
import io.github.torand.openapi2java.model.MethodInfo;
import io.github.torand.openapi2java.model.MethodParamInfo;
import io.github.torand.openapi2java.model.SecurityRequirementInfo;
import io.github.torand.openapi2java.model.TypeInfo;
import io.github.torand.openapi2java.utils.StringUtils;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MethodInfoCollector
extends BaseCollector {
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String TEXT_PLAIN = "text/plain";
    private static final Map<String, String> standardContentTypes = Map.of("application/json", "APPLICATION_JSON", "application/octet-stream", "APPLICATION_OCTET_STREAM", "application/x-www-form-urlencoded", "APPLICATION_FORM_URLENCODED", "multipart/form-data", "MULTIPART_FORM_DATA", "text/plain", "TEXT_PLAIN");
    private static final String PARAM_IN_HEADER = "header";
    private static final String PARAM_IN_QUERY = "query";
    private static final String PARAM_IN_PATH = "path";
    private static final String PARAM_IN_COOKIE = "cookie";
    private final ComponentResolver componentResolver;
    private final TypeInfoCollector typeInfoCollector;
    private final SecurityRequirementCollector securityRequirementCollector;

    public MethodInfoCollector(ComponentResolver componentResolver, TypeInfoCollector typeInfoCollector, Options opts) {
        super(opts);
        this.componentResolver = componentResolver;
        this.typeInfoCollector = typeInfoCollector;
        this.securityRequirementCollector = new SecurityRequirementCollector(opts);
    }

    public MethodInfo getMethodInfo(String verb, String path, Operation operation) {
        SecurityRequirementInfo secReqInfo;
        MethodInfo methodInfo = new MethodInfo(operation.getOperationId()).withAddedAnnotation(this.getVerbAnnotation(verb)).withAddedAnnotation(this.getPathAnnotation(path));
        if (Boolean.TRUE.equals(operation.getDeprecated())) {
            methodInfo = methodInfo.withDeprecationMessage(this.formatDeprecationMessage(operation.getExtensions()));
        }
        if (Objects.nonNull(operation.getRequestBody())) {
            methodInfo = methodInfo.withAddedAnnotation(this.getConsumesAnnotation(operation.getRequestBody()));
        }
        if (Objects.nonNull(operation.getResponses())) {
            methodInfo = methodInfo.withAddedAnnotation(this.getProducesAnnotation(operation.getResponses()));
        }
        if (CollectionHelper.nonEmpty((Collection)operation.getSecurity()) && Objects.nonNull((secReqInfo = this.securityRequirementCollector.getSequrityRequirementInfo(operation.getSecurity())).annotation())) {
            methodInfo = methodInfo.withAddedAnnotation(secReqInfo.annotation());
        }
        if (this.opts.addMpOpenApiAnnotations()) {
            methodInfo = methodInfo.withAddedAnnotation(this.getOperationAnnotation(operation));
            if (CollectionHelper.nonEmpty((Collection)operation.getParameters())) {
                ArrayList<AnnotationInfo> parameterAnnotations = new ArrayList<AnnotationInfo>();
                operation.getParameters().forEach(parameter -> parameterAnnotations.add(this.getParameterAnnotation((Parameter)parameter)));
                methodInfo = methodInfo.withAddedAnnotations(parameterAnnotations);
            }
            if (CollectionHelper.nonEmpty((Map)operation.getResponses())) {
                ArrayList<AnnotationInfo> apiResponseAnnotations = new ArrayList<AnnotationInfo>();
                operation.getResponses().forEach((code, response) -> apiResponseAnnotations.add(this.getApiResponseAnnotation((ApiResponse)response, (String)code)));
                methodInfo = methodInfo.withAddedAnnotations(apiResponseAnnotations);
                if (this.opts.useResteasyResponse()) {
                    String code2 = (String)operation.getResponses().keySet().iterator().next();
                    ApiResponse response2 = (ApiResponse)operation.getResponses().get((Object)code2);
                    methodInfo = methodInfo.withReturnType(this.getResponseType(code2, response2));
                }
            }
        }
        List<MethodParamInfo> methodParams = this.getMethodParams(operation);
        return methodInfo.withAddedParameters(methodParams);
    }

    List<MethodParamInfo> getMethodParams(Operation operation) {
        ArrayList<MethodParamInfo> methodParams = new ArrayList<MethodParamInfo>();
        if (CollectionHelper.nonEmpty((Collection)operation.getParameters())) {
            operation.getParameters().forEach(param -> {
                Parameter realParam = param;
                if (Objects.nonNull(param.get$ref())) {
                    realParam = this.componentResolver.parameters().getOrThrow(param.get$ref());
                }
                MethodParamInfo paramInfo = new MethodParamInfo().withNullable(!Boolean.TRUE.equals(realParam.getRequired())).withAddedAnnotation(this.getMethodParameterAnnotation(realParam));
                Schema realSchema = realParam.getSchema();
                if (Objects.isNull(realSchema)) {
                    throw new IllegalStateException("No schema found for ApiParameter %s".formatted(realParam.getName()));
                }
                TypeInfo paramType = this.typeInfoCollector.getTypeInfo(realParam.getSchema(), paramInfo.nullable() ? TypeInfoCollector.NullabilityResolution.FORCE_NULLABLE : TypeInfoCollector.NullabilityResolution.FORCE_NOT_NULLABLE);
                paramInfo = paramInfo.withType(paramType).withName(this.toParamName(realParam.getName())).withComment(paramType.description());
                if (Boolean.TRUE.equals(realParam.getDeprecated())) {
                    paramInfo = paramInfo.withDeprecationMessage(this.formatDeprecationMessage(realParam.getExtensions()));
                }
                methodParams.add(paramInfo);
            });
        }
        if (Objects.nonNull(operation.getRequestBody()) && CollectionHelper.nonEmpty((Map)operation.getRequestBody().getContent())) {
            operation.getRequestBody().getContent().keySet().stream().findFirst().ifPresent(mtKey -> {
                boolean isMultipart = MULTIPART_FORM_DATA.equals(mtKey);
                MediaType mt = (MediaType)operation.getRequestBody().getContent().get(mtKey);
                Schema mtSchema = mt.getSchema();
                if (Objects.nonNull(mtSchema)) {
                    if (isMultipart) {
                        if (!SchemaResolver.isObjectType(mtSchema)) {
                            throw new IllegalStateException("Multipart body should be of type 'object'");
                        }
                        if (mtSchema.getProperties().containsKey("file") && !mtSchema.getProperties().containsKey("filename")) {
                            throw new IllegalStateException("A multipart property 'file' should be accompanied by a 'filename' property containing the filename, since the File object will reference a random temporary internal filename.");
                        }
                        mtSchema.getProperties().forEach((propName, propSchema) -> {
                            MethodParamInfo paramInfo = this.getMultipartPayloadMethodParameter((String)propName, (Schema<?>)propSchema);
                            methodParams.add(paramInfo);
                        });
                    } else {
                        MethodParamInfo paramInfo = this.getSingularPayloadMethodParameter(mtSchema);
                        methodParams.add(paramInfo);
                    }
                }
            });
        }
        return methodParams;
    }

    private AnnotationInfo getVerbAnnotation(String verb) {
        return new AnnotationInfo("@%s".formatted(verb), "jakarta.ws.rs.%s".formatted(verb));
    }

    private AnnotationInfo getPathAnnotation(String path) {
        return new AnnotationInfo("@Path(\"%s\")".formatted(this.normalizePath(path)), "jakarta.ws.rs.Path");
    }

    private String getResponseType(String code, ApiResponse response) {
        String responseType = null;
        int numericCode = Integer.parseInt(code);
        if (this.isSuccessfulStatusCode(numericCode) && CollectionHelper.nonEmpty((Map)response.getContent())) {
            for (MediaType mediaType : response.getContent().values()) {
                Schema schema = mediaType.getSchema();
                TypeInfo bodyType = this.typeInfoCollector.getTypeInfo(schema);
                if (!Objects.nonNull(bodyType)) continue;
                String fullName = bodyType.getFullName();
                if (Objects.isNull(responseType)) {
                    responseType = fullName;
                    continue;
                }
                if (fullName.equals(responseType)) continue;
                responseType = this.opts.useKotlinSyntax() ? "*" : "?";
                break;
            }
        }
        return responseType;
    }

    private MethodParamInfo getSingularPayloadMethodParameter(Schema<?> schema) {
        TypeInfo bodyType = this.typeInfoCollector.getTypeInfo(schema, TypeInfoCollector.NullabilityResolution.FORCE_NOT_NULLABLE);
        return new MethodParamInfo(this.toParamName(bodyType.name())).withNullable(false).withType(bodyType).withComment(bodyType.description());
    }

    private MethodParamInfo getMultipartPayloadMethodParameter(String name, Schema<?> schema) {
        TypeInfo bodyType;
        String partMediaType = null;
        if ("file".equals(name)) {
            bodyType = new TypeInfo().withName("File").withAddedNormalImport("java.io.File").withNullable(false).withAddedAnnotation(new AnnotationInfo("@NotNull", "jakarta.validation.constraints.NotNull")).withDescription(schema.getDescription());
            partMediaType = APPLICATION_OCTET_STREAM;
        } else {
            bodyType = this.typeInfoCollector.getTypeInfo(schema);
            if (SchemaResolver.isObjectType(schema)) {
                throw new IllegalStateException("Multipart property of type 'object' not supported. Use $ref instead.");
            }
            partMediaType = APPLICATION_JSON;
            if (bodyType.primitive() || bodyType.isArray() && bodyType.itemType().primitive()) {
                partMediaType = TEXT_PLAIN;
            }
        }
        if (StringHelper.nonBlank((String)schema.getContentMediaType())) {
            partMediaType = schema.getContentMediaType();
        }
        ConstantValue partMediaTypeConstant = this.getMediaTypeConstant(partMediaType);
        return new MethodParamInfo(name).withNullable(bodyType.nullable()).withType(bodyType).withComment(bodyType.description()).withAddedAnnotation(new AnnotationInfo("@RestForm(\"%s\")".formatted(name), "org.jboss.resteasy.reactive.RestForm")).withAddedAnnotation(new AnnotationInfo("@PartType(%s)".formatted(partMediaTypeConstant.value()), "org.jboss.resteasy.reactive.PartType")).withAddedImports(partMediaTypeConstant);
    }

    private AnnotationInfo getConsumesAnnotation(RequestBody requestBody) {
        ArrayList mediaTypes = new ArrayList();
        if (CollectionHelper.nonEmpty((Map)requestBody.getContent())) {
            StreamHelper.streamSafely((Iterable)requestBody.getContent().keySet()).map(this::getMediaTypeConstant).forEach(mediaTypes::add);
        }
        String mediaTypesString = this.formatAnnotationDefaultParam(mediaTypes.stream().map(ConstantValue::value).toList());
        return new AnnotationInfo("@Consumes(%s)".formatted(mediaTypesString)).withAddedNormalImport("jakarta.ws.rs.Consumes").withAddedImports(mediaTypes);
    }

    private AnnotationInfo getProducesAnnotation(ApiResponses responses) {
        ArrayList<ConstantValue> mediaTypes = new ArrayList<ConstantValue>();
        mediaTypes.add(new ConstantValue("APPLICATION_JSON").withStaticImport("jakarta.ws.rs.core.MediaType.APPLICATION_JSON"));
        this.getSuccessResponse(responses).ifPresent(apiResponse -> {
            if (Objects.nonNull(apiResponse.getContent())) {
                apiResponse.getContent().keySet().stream().filter(mt -> !APPLICATION_JSON.equals(mt)).map(this::getMediaTypeConstant).forEach(mediaTypes::add);
            }
        });
        String mediaTypesString = this.formatAnnotationDefaultParam(mediaTypes.stream().map(ConstantValue::value).toList());
        return new AnnotationInfo("@Produces(%s)".formatted(mediaTypesString)).withAddedNormalImport("jakarta.ws.rs.Produces").withAddedImports(mediaTypes);
    }

    private AnnotationInfo getOperationAnnotation(Operation operation) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("operationId = \"%s\"".formatted(operation.getOperationId()));
        params.add("summary = \"%s\"".formatted(operation.getSummary()));
        if (Boolean.TRUE.equals(operation.getDeprecated())) {
            params.add("deprecated = true");
        }
        return new AnnotationInfo("@Operation(%s)".formatted(StringUtils.joinCsv(params)), "org.eclipse.microprofile.openapi.annotations.Operation");
    }

    private AnnotationInfo getParameterAnnotation(Parameter parameter) {
        Parameter realParameter = parameter;
        if (Objects.nonNull(parameter.get$ref())) {
            realParameter = this.componentResolver.parameters().getOrThrow(parameter.get$ref());
        }
        AnnotationInfo parameterAnnotation = new AnnotationInfo();
        ArrayList<String> params = new ArrayList<String>();
        ConstantValue inValue = this.getParameterInValue(realParameter);
        String inName = this.opts.useKotlinSyntax() ? "`in`" : "in";
        params.add("%s = %s".formatted(inName, inValue.value()));
        parameterAnnotation = parameterAnnotation.withAddedImports(inValue);
        if (inValue.value().equalsIgnoreCase(PARAM_IN_HEADER)) {
            ConstantValue headerNameConstant = this.getHeaderNameConstant(realParameter.getName());
            params.add("name = %s".formatted(headerNameConstant.value()));
            parameterAnnotation = parameterAnnotation.withAddedImports(headerNameConstant);
        } else {
            params.add("name = \"%s\"".formatted(realParameter.getName()));
        }
        params.add("description = \"%s\"".formatted(this.normalizeDescription(realParameter.getDescription())));
        if (Boolean.TRUE.equals(realParameter.getRequired())) {
            params.add("required = true");
        }
        if (Objects.nonNull(realParameter.getSchema())) {
            AnnotationInfo schemaAnnotation = this.getSchemaAnnotation(realParameter.getSchema());
            params.add("schema = %s".formatted(schemaAnnotation.annotation()));
            parameterAnnotation = parameterAnnotation.withAddedImports(schemaAnnotation);
        }
        if (CollectionHelper.nonEmpty((Map)realParameter.getContent())) {
            ArrayList contentAnnotations = new ArrayList();
            realParameter.getContent().forEach((contentType, mediaType) -> contentAnnotations.add(this.getContentAnnotation((String)contentType, (MediaType)mediaType)));
            params.add("content = %s".formatted(this.formatAnnotationNamedParam(contentAnnotations.stream().map(AnnotationInfo::annotation).toList())));
            parameterAnnotation = parameterAnnotation.withAddedImports(contentAnnotations);
        }
        if (Objects.nonNull(realParameter.getStyle())) {
            Parameter.StyleEnum defaultStyle = this.getDefaultParameterStyle(realParameter);
            if (!realParameter.getStyle().equals((Object)defaultStyle)) {
                ConstantValue parameterStyle = this.getParameterStyle(realParameter);
                params.add("style = %s".formatted(parameterStyle.value()));
                parameterAnnotation = parameterAnnotation.withAddedImports(parameterStyle);
            }
        }
        if (Objects.nonNull(realParameter.getExplode())) {
            boolean defaultValue = Parameter.StyleEnum.FORM.equals((Object)realParameter.getStyle());
            if (!realParameter.getExplode().equals(defaultValue)) {
                ConstantValue parameterExplode = this.getParameterExplode(realParameter);
                params.add("explode = %s".formatted(parameterExplode.value()));
                parameterAnnotation = parameterAnnotation.withAddedImports(parameterExplode);
            }
        }
        if (Boolean.TRUE.equals(realParameter.getDeprecated())) {
            params.add("deprecated = true");
        }
        return parameterAnnotation.withAnnotation("@Parameter(%s)".formatted(StringUtils.joinCsv(params))).withAddedNormalImport("org.eclipse.microprofile.openapi.annotations.parameters.Parameter");
    }

    private Parameter.StyleEnum getDefaultParameterStyle(Parameter parameter) {
        return switch (parameter.getIn()) {
            case PARAM_IN_HEADER -> Parameter.StyleEnum.SIMPLE;
            case PARAM_IN_QUERY -> Parameter.StyleEnum.FORM;
            case PARAM_IN_PATH -> Parameter.StyleEnum.SIMPLE;
            case PARAM_IN_COOKIE -> Parameter.StyleEnum.FORM;
            default -> throw new IllegalStateException("Parameter in-value %s not supported".formatted(parameter.getIn()));
        };
    }

    private ConstantValue getParameterStyle(Parameter parameter) {
        String style = switch (parameter.getStyle()) {
            default -> throw new IncompatibleClassChangeError();
            case Parameter.StyleEnum.MATRIX -> "MATRIX";
            case Parameter.StyleEnum.LABEL -> "LABEL";
            case Parameter.StyleEnum.FORM -> "FORM";
            case Parameter.StyleEnum.SIMPLE -> "SIMPLE";
            case Parameter.StyleEnum.SPACEDELIMITED -> "SPACEDELIMITED";
            case Parameter.StyleEnum.PIPEDELIMITED -> "PIPEDELIMITED";
            case Parameter.StyleEnum.DEEPOBJECT -> "DEEPOBJECT";
        };
        return new ConstantValue(style).withStaticImport("org.eclipse.microprofile.openapi.annotations.enums.ParameterStyle." + style);
    }

    private ConstantValue getParameterExplode(Parameter parameter) {
        String explode = Boolean.TRUE.equals(parameter.getExplode()) ? "TRUE" : "FALSE";
        return new ConstantValue(explode).withStaticImport("org.eclipse.microprofile.openapi.annotations.enums.Explode." + explode);
    }

    private ConstantValue getParameterInValue(Parameter parameter) {
        String inValue = switch (parameter.getIn().toLowerCase()) {
            case "" -> "DEFAULT";
            case PARAM_IN_HEADER -> "HEADER";
            case PARAM_IN_QUERY -> "QUERY";
            case PARAM_IN_PATH -> "PATH";
            case PARAM_IN_COOKIE -> "COOKIE";
            default -> throw new IllegalStateException("Parameter in-value %s not supported".formatted(parameter.getIn()));
        };
        return new ConstantValue(inValue).withStaticImport("org.eclipse.microprofile.openapi.annotations.enums.ParameterIn." + inValue);
    }

    private AnnotationInfo getApiResponseAnnotation(ApiResponse response, String statusCode) {
        ApiResponse realResponse = response;
        if (Objects.nonNull(response.get$ref())) {
            realResponse = this.componentResolver.responses().getOrThrow(response.get$ref());
        }
        AnnotationInfo apiResponseAnnotation = new AnnotationInfo();
        ArrayList<String> params = new ArrayList<String>();
        params.add("responseCode = \"%s\"".formatted(statusCode));
        params.add("description = \"%s\"".formatted(this.normalizeDescription(realResponse.getDescription())));
        if (CollectionHelper.nonEmpty((Map)realResponse.getHeaders())) {
            ArrayList headerAnnotations = new ArrayList();
            realResponse.getHeaders().forEach((name, header) -> headerAnnotations.add(this.getHeaderAnnotation((String)name, (Header)header)));
            params.add("headers = %s".formatted(this.formatAnnotationNamedParam(headerAnnotations.stream().map(AnnotationInfo::annotation).toList())));
            apiResponseAnnotation = apiResponseAnnotation.withAddedImports(headerAnnotations);
        }
        if (CollectionHelper.nonEmpty((Map)realResponse.getContent())) {
            ArrayList contentAnnotations = new ArrayList();
            realResponse.getContent().forEach((contentType, mediaType) -> contentAnnotations.add(this.getContentAnnotation((String)contentType, (MediaType)mediaType)));
            params.add("content = %s".formatted(this.formatAnnotationNamedParam(contentAnnotations.stream().map(AnnotationInfo::annotation).toList())));
            apiResponseAnnotation = apiResponseAnnotation.withAddedImports(contentAnnotations);
        }
        return apiResponseAnnotation.withAnnotation("@APIResponse(%s)".formatted(StringUtils.joinCsv(params))).withAddedNormalImport("org.eclipse.microprofile.openapi.annotations.responses.APIResponse");
    }

    private AnnotationInfo getMethodParameterAnnotation(Parameter parameter) {
        String paramAnnotationName = switch (parameter.getIn().toLowerCase()) {
            case PARAM_IN_HEADER -> "HeaderParam";
            case PARAM_IN_QUERY -> "QueryParam";
            case PARAM_IN_PATH -> "PathParam";
            case PARAM_IN_COOKIE -> "CookieParam";
            default -> throw new IllegalStateException("Parameter in-value %s not supported".formatted(parameter.getIn()));
        };
        String annotationImport = "jakarta.ws.rs." + paramAnnotationName;
        if (paramAnnotationName.equals("HeaderParam")) {
            ConstantValue headerNameConstant = this.getHeaderNameConstant(parameter.getName());
            return new AnnotationInfo("@%s(%s)".formatted(paramAnnotationName, headerNameConstant.value())).withAddedNormalImport(annotationImport).withAddedImports(headerNameConstant);
        }
        return new AnnotationInfo("@%s(\"%s\")".formatted(paramAnnotationName, parameter.getName())).withAddedNormalImport(annotationImport);
    }

    private AnnotationInfo getContentAnnotation(String contentType, MediaType mediaType) {
        ConstantValue mediaTypeConstant = this.getMediaTypeConstant(contentType);
        AnnotationInfo schemaAnnotation = this.getSchemaAnnotation(mediaType.getSchema());
        return new AnnotationInfo(this.formatInnerAnnotation("Content(mediaType = %s, schema = %s)", mediaTypeConstant.value(), schemaAnnotation.annotation())).withAddedNormalImport("org.eclipse.microprofile.openapi.annotations.media.Content").withAddedImports(mediaTypeConstant).withAddedImports(schemaAnnotation);
    }

    private AnnotationInfo getSchemaAnnotation(Schema<?> schema) {
        AnnotationInfo schemaAnnotation = new AnnotationInfo();
        ArrayList<String> params = new ArrayList<String>();
        TypeInfo bodyType = this.typeInfoCollector.getTypeInfo(schema);
        schemaAnnotation = schemaAnnotation.withAddedImports(bodyType.imports());
        if (Objects.nonNull(bodyType.itemType())) {
            schemaAnnotation = schemaAnnotation.withAddedStaticImport("org.eclipse.microprofile.openapi.annotations.enums.SchemaType.ARRAY").withAddedImports(bodyType.itemType().imports());
            params.add("type = ARRAY");
            bodyType = bodyType.itemType();
        }
        params.add("implementation = %s".formatted(this.formatClassRef(bodyType.name())));
        if (Objects.nonNull(schema.getDefault())) {
            params.add("defaultValue = \"%s\"".formatted(schema.getDefault().toString()));
        }
        if (StringHelper.nonBlank((String)bodyType.schemaFormat())) {
            params.add("format = \"%s\"".formatted(bodyType.schemaFormat()));
        }
        if (StringHelper.nonBlank((String)bodyType.schemaPattern())) {
            params.add("pattern = \"%s\"".formatted(bodyType.schemaPattern()));
        }
        return schemaAnnotation.withAnnotation(this.formatInnerAnnotation("Schema(%s)", StringUtils.joinCsv(params))).withAddedNormalImport("org.eclipse.microprofile.openapi.annotations.media.Schema");
    }

    private AnnotationInfo getHeaderAnnotation(String name, Header header) {
        Header realHeader = header;
        if (Objects.nonNull(header.get$ref())) {
            realHeader = this.componentResolver.headers().getOrThrow(header.get$ref());
        }
        AnnotationInfo schemaAnnotation = this.getSchemaAnnotation(realHeader.getSchema());
        return new AnnotationInfo(this.formatInnerAnnotation("Header(name = \"%s\", description = \"%s\", schema = %s)", name, this.normalizeDescription(realHeader.getDescription()), schemaAnnotation.annotation())).withAddedNormalImport("org.eclipse.microprofile.openapi.annotations.headers.Header").withAddedImports(schemaAnnotation);
    }

    private String toParamName(String paramName) {
        Objects.requireNonNull(paramName);
        if (StringHelper.nonBlank((String)this.opts.pojoNameSuffix()) && paramName.endsWith(this.opts.pojoNameSuffix())) {
            paramName = StringHelper.stripTail((String)paramName, (int)this.opts.pojoNameSuffix().length());
        }
        paramName = paramName.replace("-", "");
        paramName = paramName.replace("[]", "s");
        return StringHelper.uncapitalize((String)paramName);
    }

    private Optional<ApiResponse> getSuccessResponse(ApiResponses responses) {
        Objects.requireNonNull(responses);
        return responses.keySet().stream().filter(sc -> sc.startsWith("2")).findFirst().map(arg_0 -> responses.get(arg_0));
    }

    private ConstantValue getMediaTypeConstant(String contentType) {
        if (standardContentTypes.containsKey(contentType)) {
            contentType = standardContentTypes.get(contentType);
            return new ConstantValue(contentType).withStaticImport("jakarta.ws.rs.core.MediaType." + contentType);
        }
        return new ConstantValue(StringHelper.quote((String)contentType));
    }

    private boolean isSuccessfulStatusCode(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }
}

