/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.ComponentResolver;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.ImportInfo;
import io.github.torand.openapi2java.model.OpenApiDefInfo;
import io.github.torand.openapi2java.utils.StringUtils;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OpenApiDefInfoCollector
extends BaseCollector {
    private final ComponentResolver componentResolver;

    public OpenApiDefInfoCollector(ComponentResolver componentResolver, Options opts) {
        super(opts);
        this.componentResolver = componentResolver;
    }

    public OpenApiDefInfo getOpenApiDefInfo(String name, List<SecurityRequirement> securityRequirements) {
        OpenApiDefInfo openApiDefInfo = new OpenApiDefInfo(name).withAddedNormalImport("jakarta.ws.rs.core.Application");
        if (CollectionHelper.nonEmpty(securityRequirements)) {
            openApiDefInfo = openApiDefInfo.withAddedAnnotation(this.getSecuritySchemesAnnotation(securityRequirements));
        }
        return openApiDefInfo;
    }

    private AnnotationInfo getSecuritySchemesAnnotation(List<SecurityRequirement> securityRequirements) {
        ArrayList securitySchemeAnnotations = new ArrayList();
        securityRequirements.forEach(sr -> sr.keySet().forEach(schemeName -> securitySchemeAnnotations.add(this.getSecuritySchemeAnnotation((String)schemeName))));
        return new AnnotationInfo("@SecuritySchemes(%s)".formatted(this.formatAnnotationDefaultParam(securitySchemeAnnotations.stream().map(AnnotationInfo::annotation).toList())), "org.eclipse.microprofile.openapi.annotations.security.SecuritySchemes").withAddedImports(securitySchemeAnnotations);
    }

    private AnnotationInfo getSecuritySchemeAnnotation(String name) {
        SecurityScheme securityScheme = this.componentResolver.securitySchemes().getOrThrow(name);
        ImportInfo imports = ImportInfo.empty();
        ArrayList<String> params = new ArrayList<String>();
        params.add("securitySchemeName = \"%s\"".formatted(name));
        if (StringHelper.nonBlank((String)securityScheme.getDescription())) {
            params.add("description = \"%s\"".formatted(this.normalizeDescription(securityScheme.getDescription())));
        }
        imports = imports.withAddedNormalImport("org.eclipse.microprofile.openapi.annotations.enums.SecuritySchemeType");
        params.add("type = SecuritySchemeType.%s".formatted(securityScheme.getType().name()));
        switch (securityScheme.getType()) {
            case APIKEY: {
                params.add("name = \"%s\"".formatted(securityScheme.getName()));
                break;
            }
            case HTTP: {
                params.add("scheme = \"%s\"".formatted(securityScheme.getScheme()));
                if (!Objects.nonNull(securityScheme.getBearerFormat())) break;
                params.add("bearerFormat = \"%s\"".formatted(securityScheme.getBearerFormat()));
                break;
            }
            case OAUTH2: {
                if (!Objects.nonNull(securityScheme.getFlows())) break;
                AnnotationInfo flowsAnnotation = this.getOAuthFlowsAnnotation(securityScheme.getFlows());
                imports = imports.withAddedImports(flowsAnnotation);
                params.add("flows = %s".formatted(flowsAnnotation.annotation()));
                break;
            }
            case OPENIDCONNECT: {
                params.add("openIdConnectUrl = \"%s\"".formatted(securityScheme.getOpenIdConnectUrl()));
                break;
            }
            case MUTUALTLS: {
                throw new IllegalStateException("Security scheme MUTUALTLS not supported");
            }
        }
        return new AnnotationInfo((this.opts.useKotlinSyntax() ? "" : "@") + "SecurityScheme(%s)".formatted(StringUtils.joinCsv(params)), "org.eclipse.microprofile.openapi.annotations.security.SecurityScheme").withAddedImports(imports);
    }

    private AnnotationInfo getOAuthFlowsAnnotation(OAuthFlows flows) {
        AnnotationInfo flowAnnotation;
        ImportInfo imports = ImportInfo.empty();
        ArrayList<String> params = new ArrayList<String>();
        if (Objects.nonNull(flows.getAuthorizationCode())) {
            flowAnnotation = this.getOAuthFlowAnnotation(flows.getAuthorizationCode());
            imports = imports.withAddedImports(flowAnnotation);
            params.add("authorizationCode = %s".formatted(flowAnnotation.annotation()));
        }
        if (Objects.nonNull(flows.getImplicit())) {
            flowAnnotation = this.getOAuthFlowAnnotation(flows.getImplicit());
            imports = imports.withAddedImports(flowAnnotation);
            params.add("implicit = %s".formatted(flowAnnotation.annotation()));
        }
        if (Objects.nonNull(flows.getClientCredentials())) {
            flowAnnotation = this.getOAuthFlowAnnotation(flows.getClientCredentials());
            imports = imports.withAddedImports(flowAnnotation);
            params.add("clientCredentials = %s".formatted(flowAnnotation.annotation()));
        }
        if (Objects.nonNull(flows.getPassword())) {
            flowAnnotation = this.getOAuthFlowAnnotation(flows.getPassword());
            imports = imports.withAddedImports(flowAnnotation);
            params.add("password = %s".formatted(flowAnnotation.annotation()));
        }
        return new AnnotationInfo((this.opts.useKotlinSyntax() ? "" : "@") + "OAuthFlows(%s)".formatted(StringUtils.joinCsv(params)), "org.eclipse.microprofile.openapi.annotations.security.OAuthFlows").withAddedImports(imports);
    }

    private AnnotationInfo getOAuthFlowAnnotation(OAuthFlow flow) {
        ImportInfo imports = ImportInfo.empty();
        ArrayList<String> params = new ArrayList<String>();
        if (StringHelper.nonBlank((String)flow.getAuthorizationUrl())) {
            params.add("authorizationUrl = \"%s\"".formatted(flow.getAuthorizationUrl()));
        }
        if (StringHelper.nonBlank((String)flow.getTokenUrl())) {
            params.add("tokenUrl = \"%s\"".formatted(flow.getTokenUrl()));
        }
        if (StringHelper.nonBlank((String)flow.getRefreshUrl())) {
            params.add("refreshUrl = \"%s\"".formatted(flow.getRefreshUrl()));
        }
        if (CollectionHelper.nonEmpty((Map)flow.getScopes())) {
            List<AnnotationInfo> scopesAnnotations = this.getScopesAnnotations(flow.getScopes());
            imports = imports.withAddedImports(scopesAnnotations);
            params.add("scopes = %s".formatted(this.formatAnnotationNamedParam(scopesAnnotations.stream().map(AnnotationInfo::annotation).toList())));
        }
        return new AnnotationInfo((this.opts.useKotlinSyntax() ? "" : "@") + "OAuthFlow(%s)".formatted(StringUtils.joinCsv(params)), "org.eclipse.microprofile.openapi.annotations.security.OAuthFlow").withAddedImports(imports);
    }

    private List<AnnotationInfo> getScopesAnnotations(Scopes scopes) {
        return scopes.keySet().stream().map(name -> this.getScopeAnnotation((String)name, (String)scopes.get(name))).toList();
    }

    private AnnotationInfo getScopeAnnotation(String name, String description) {
        return new AnnotationInfo((this.opts.useKotlinSyntax() ? "" : "@") + "OAuthScope(name = \"%s\", description = \"%s\")".formatted(name, this.normalizeDescription(description)), "org.eclipse.microprofile.openapi.annotations.security.OAuthScope");
    }
}

