/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.ComponentResolver;
import io.github.torand.openapi2java.collectors.Extensions;
import io.github.torand.openapi2java.collectors.MethodInfoCollector;
import io.github.torand.openapi2java.collectors.SecurityRequirementCollector;
import io.github.torand.openapi2java.collectors.TypeInfoCollector;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.ConstantValue;
import io.github.torand.openapi2java.model.MethodInfo;
import io.github.torand.openapi2java.model.ResourceInfo;
import io.github.torand.openapi2java.model.SecurityRequirementInfo;
import io.github.torand.openapi2java.utils.StringUtils;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceInfoCollector
extends BaseCollector {
    private final MethodInfoCollector methodInfoCollector;
    private final SecurityRequirementCollector securityRequirementCollector;

    public ResourceInfoCollector(ComponentResolver componentResolver, Options opts) {
        super(opts);
        TypeInfoCollector typeInfoCollector = new TypeInfoCollector(componentResolver.schemas(), opts);
        this.methodInfoCollector = new MethodInfoCollector(componentResolver, typeInfoCollector, opts);
        this.securityRequirementCollector = new SecurityRequirementCollector(opts);
    }

    public ResourceInfo getResourceInfo(String resourceName, Map<String, PathItem> paths, List<SecurityRequirement> securityRequirements, Tag tag) {
        ResourceInfo resourceInfo = new ResourceInfo(resourceName + this.opts.resourceNameSuffix());
        resourceInfo = this.opts.useResteasyResponse() ? resourceInfo.withAddedNormalImport("org.jboss.resteasy.reactive.RestResponse") : resourceInfo.withAddedNormalImport("jakarta.ws.rs.core.Response");
        if (CollectionHelper.nonEmpty(securityRequirements)) {
            SecurityRequirementInfo secReqInfo = this.securityRequirementCollector.getSequrityRequirementInfo(securityRequirements);
            resourceInfo = resourceInfo.withAddedAnnotation(secReqInfo.annotation());
        }
        if (this.opts.addMpOpenApiAnnotations() && Objects.nonNull(tag)) {
            AnnotationInfo tagAnnotation = this.getTagAnnotation(tag);
            resourceInfo = resourceInfo.withAddedAnnotation(tagAnnotation);
        }
        if (this.opts.addMpRestClientAnnotations()) {
            List<String> providers;
            String clientHeadersFactory;
            Optional<Map<String, Object>> maybeHeaders;
            Object configKey = this.opts.resourceConfigKeyOverride();
            if (StringHelper.isBlank((String)configKey)) {
                configKey = Objects.nonNull(tag) ? Extensions.extensions(tag.getExtensions()).getString("x-restclient-configkey").orElse(tag.getName().toLowerCase() + "-api") : resourceName.toLowerCase() + "-api";
            }
            AnnotationInfo registerRestClientAnnotation = ResourceInfoCollector.getRegisterRestClientAnnotation((String)configKey);
            resourceInfo = resourceInfo.withAddedAnnotation(registerRestClientAnnotation);
            if (Objects.nonNull(tag) && (maybeHeaders = Extensions.extensions(tag.getExtensions()).getMap("x-restclient-headers")).isPresent()) {
                List<AnnotationInfo> clientHeaderAnnotations = this.getClientHeaderParamAnnotations(maybeHeaders.get());
                resourceInfo = resourceInfo.withAddedAnnotations(clientHeaderAnnotations);
            }
            if (StringHelper.isBlank((String)(clientHeadersFactory = this.opts.resourceClientHeadersFactoryOverride()))) {
                String string = clientHeadersFactory = Objects.nonNull(tag) ? Extensions.extensions(tag.getExtensions()).getString("x-restclient-headersfactory").orElse("") : "";
            }
            if (StringHelper.nonBlank((String)clientHeadersFactory)) {
                AnnotationInfo registerClientHeadersAnnotation = this.getRegisterClientHeadersAnnotation(clientHeadersFactory);
                resourceInfo = resourceInfo.withAddedAnnotation(registerClientHeadersAnnotation);
            }
            if (CollectionHelper.isEmpty(providers = this.opts.resourceProvidersOverride())) {
                List<Object> list = providers = Objects.nonNull(tag) ? Extensions.extensions(tag.getExtensions()).getStringArray("x-restclient-providers").orElse(Collections.emptyList()) : Collections.emptyList();
            }
            if (CollectionHelper.nonEmpty(providers)) {
                List<AnnotationInfo> registerProviderAnnotations = this.getRegisterProviderAnnotations(providers);
                resourceInfo = resourceInfo.withAddedAnnotations(registerProviderAnnotations);
            }
            if (this.opts.useOidcClientAnnotation()) {
                AnnotationInfo oidcClientFilterAnnotation = ResourceInfoCollector.getOidcClientFilterAnnotation((String)configKey);
                resourceInfo = resourceInfo.withAddedAnnotation(oidcClientFilterAnnotation);
            }
        }
        AnnotationInfo pathAnnotation = this.getPathAnnotation(resourceInfo);
        resourceInfo = resourceInfo.withAddedAnnotation(pathAnnotation);
        String tagName = Objects.nonNull(tag) ? tag.getName() : null;
        ArrayList methods = new ArrayList();
        paths.forEach((path, pathInfo) -> {
            if (this.shouldProcessOperation(pathInfo.getGet(), tagName)) {
                methods.add(this.methodInfoCollector.getMethodInfo("GET", (String)path, pathInfo.getGet()));
            }
            if (this.shouldProcessOperation(pathInfo.getPost(), tagName)) {
                methods.add(this.methodInfoCollector.getMethodInfo("POST", (String)path, pathInfo.getPost()));
            }
            if (this.shouldProcessOperation(pathInfo.getDelete(), tagName)) {
                methods.add(this.methodInfoCollector.getMethodInfo("DELETE", (String)path, pathInfo.getDelete()));
            }
            if (this.shouldProcessOperation(pathInfo.getPut(), tagName)) {
                methods.add(this.methodInfoCollector.getMethodInfo("PUT", (String)path, pathInfo.getPut()));
            }
            if (this.shouldProcessOperation(pathInfo.getPatch(), tagName)) {
                methods.add(this.methodInfoCollector.getMethodInfo("PATCH", (String)path, pathInfo.getPatch()));
            }
        });
        for (MethodInfo method : methods) {
            resourceInfo = resourceInfo.withAddedMethod(method);
        }
        return resourceInfo;
    }

    private List<AnnotationInfo> getRegisterProviderAnnotations(List<String> providers) {
        ArrayList<AnnotationInfo> registerProviderAnnotations = new ArrayList<AnnotationInfo>();
        providers.forEach(provider -> {
            AnnotationInfo registerProviderAnnotation = new AnnotationInfo("@RegisterProvider(%s)".formatted(this.formatClassRef(StringUtils.getClassNameFromFqn(provider))), "org.eclipse.microprofile.rest.client.annotation.RegisterProvider").withAddedNormalImport((String)provider);
            registerProviderAnnotations.add(registerProviderAnnotation);
        });
        return registerProviderAnnotations;
    }

    private static AnnotationInfo getOidcClientFilterAnnotation(String configKey) {
        return new AnnotationInfo("@OidcClientFilter(\"%s\")".formatted(configKey), "io.quarkus.oidc.client.filter.OidcClientFilter");
    }

    private AnnotationInfo getRegisterClientHeadersAnnotation(String headerFactory) {
        return new AnnotationInfo("@RegisterClientHeaders(%s)".formatted(this.formatClassRef(StringUtils.getClassNameFromFqn(headerFactory))), "org.eclipse.microprofile.rest.client.annotation.RegisterClientHeaders").withAddedNormalImport(headerFactory);
    }

    private AnnotationInfo getPathAnnotation(ResourceInfo resourceInfo) {
        return new AnnotationInfo("@Path(ROOT_PATH)", "jakarta.ws.rs.Path").withAddedStaticImport("%s.%s.ROOT_PATH".formatted(this.opts.rootPackage(), resourceInfo.name()));
    }

    private AnnotationInfo getTagAnnotation(Tag tag) {
        return new AnnotationInfo("@Tag(name = \"%s\", description = \"%s\")".formatted(tag.getName(), this.normalizeDescription(tag.getDescription())), "org.eclipse.microprofile.openapi.annotations.tags.Tag");
    }

    private static AnnotationInfo getRegisterRestClientAnnotation(String configKey) {
        return new AnnotationInfo("@RegisterRestClient(configKey = \"%s\")".formatted(configKey), "org.eclipse.microprofile.rest.client.inject.RegisterRestClient");
    }

    private List<AnnotationInfo> getClientHeaderParamAnnotations(Map<String, Object> headers) {
        ArrayList<AnnotationInfo> clientHeaderAnnotations = new ArrayList<AnnotationInfo>();
        if (CollectionHelper.nonEmpty(headers)) {
            headers.forEach((header, value) -> {
                ConstantValue headerName = this.getHeaderNameConstant((String)header);
                String formattedValue = this.formatAnnotationNamedParam(List.of("\"%s\"".formatted(value)));
                AnnotationInfo clientHeaderAnnotation = new AnnotationInfo("@ClientHeaderParam(name = %s, value = %s)".formatted(headerName.value(), formattedValue)).withAddedNormalImport("org.eclipse.microprofile.rest.client.annotation.ClientHeaderParam").withAddedImports(headerName);
                clientHeaderAnnotations.add(clientHeaderAnnotation);
            });
        }
        return clientHeaderAnnotations;
    }

    private boolean shouldProcessOperation(Operation operation, String tag) {
        if (Objects.isNull(operation)) {
            return false;
        }
        if (Objects.isNull(tag)) {
            return true;
        }
        return Objects.nonNull(operation.getTags()) && operation.getTags().contains(tag);
    }
}

