/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.javacommons.lang.Exceptions;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Map;
import java.util.Optional;

public class ResponseResolver {
    private final Map<String, ApiResponse> responses;

    ResponseResolver(Map<String, ApiResponse> responses) {
        this.responses = responses;
    }

    public String getResponseName(String ref) {
        return ref.replace("#/components/responses/", "");
    }

    public Optional<ApiResponse> get(String ref) {
        return Optional.ofNullable(this.responses.get(this.getResponseName(ref)));
    }

    public ApiResponse getOrThrow(String ref) {
        return this.get(ref).orElseThrow(Exceptions.illegalStateException((String)"Response %s not found", (Object[])new Object[]{ref}));
    }
}

