/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.SecurityRequirementInfo;
import io.github.torand.openapi2java.utils.StringUtils;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SecurityRequirementCollector
extends BaseCollector {
    public SecurityRequirementCollector(Options opts) {
        super(opts);
    }

    public SecurityRequirementInfo getSequrityRequirementInfo(List<SecurityRequirement> securityRequirements) {
        if (securityRequirements.size() > 1) {
            throw new IllegalStateException("Multiple alternative security requirements not supported");
        }
        SecurityRequirement securityRequirement = securityRequirements.get(0);
        if (securityRequirement.size() > 1) {
            throw new IllegalStateException("Multiple mandatory security scheme names not supported");
        }
        String scheme = (String)securityRequirement.keySet().iterator().next();
        SecurityRequirementInfo secReqInfo = new SecurityRequirementInfo(scheme).withScopes((Collection)securityRequirement.get((Object)scheme));
        if (this.opts.addMpOpenApiAnnotations()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("name = \"%s\"".formatted(scheme));
            if (CollectionHelper.nonEmpty(secReqInfo.scopes())) {
                params.add("scopes = %s".formatted(this.formatAnnotationNamedParam(StringHelper.quoteAll(secReqInfo.scopes()))));
            }
            secReqInfo = secReqInfo.withAnnotation(new AnnotationInfo("@SecurityRequirement(%s)".formatted(StringUtils.joinCsv(params)), "org.eclipse.microprofile.openapi.annotations.security.SecurityRequirement"));
        }
        return secReqInfo;
    }
}

