/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.collectors;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.lang.Exceptions;
import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.javacommons.stream.StreamHelper;
import io.github.torand.openapi2java.collectors.BaseCollector;
import io.github.torand.openapi2java.collectors.Extensions;
import io.github.torand.openapi2java.collectors.SchemaResolver;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.TypeInfo;
import io.github.torand.openapi2java.utils.StringUtils;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TypeInfoCollector
extends BaseCollector {
    private final SchemaResolver schemaResolver;

    public TypeInfoCollector(SchemaResolver schemaResolver, Options opts) {
        super(opts);
        this.schemaResolver = schemaResolver;
    }

    public <T> TypeInfo getTypeInfo(Schema<T> schema) {
        return this.getTypeInfo(schema, NullabilityResolution.FROM_SCHEMA);
    }

    public TypeInfo getTypeInfo(Schema<?> schema, NullabilityResolution nullabilityResolution) {
        if (CollectionHelper.isEmpty((Collection)schema.getTypes())) {
            boolean nullable = this.isNullable(schema, nullabilityResolution);
            if (Objects.nonNull(schema.getAnyOf())) {
                throw new IllegalStateException("Schema 'anyOf' not supported");
            }
            if (Objects.nonNull(schema.getOneOf())) {
                List oneOfSchemas = schema.getOneOf();
                Schema<?> subSchema = this.getNonNullableSubSchema(oneOfSchemas).orElseThrow(Exceptions.illegalStateException((String)"Schema 'oneOf' must contain a non-nullable sub-schema", (Object[])new Object[0]));
                return this.getTypeInfo(subSchema, nullable ? NullabilityResolution.FORCE_NULLABLE : NullabilityResolution.FORCE_NOT_NULLABLE);
            }
            if (Objects.nonNull(schema.getAllOf()) && schema.getAllOf().size() == 1) {
                return this.getTypeInfo((Schema)schema.getAllOf().get(0), nullable ? NullabilityResolution.FORCE_NULLABLE : NullabilityResolution.FORCE_NOT_NULLABLE);
            }
            String ref = schema.get$ref();
            if (StringHelper.nonBlank((String)ref)) {
                TypeInfo typeInfo;
                if (this.schemaResolver.isPrimitiveType(ref)) {
                    Schema<?> refSchema = this.schemaResolver.getOrThrow(ref);
                    typeInfo = this.getTypeInfo(refSchema, nullable ? NullabilityResolution.FORCE_NULLABLE : NullabilityResolution.FORCE_NOT_NULLABLE);
                } else {
                    typeInfo = new TypeInfo().withName(this.schemaResolver.getTypeName(ref) + this.opts.pojoNameSuffix()).withNullable(nullable);
                    String modelSubpackage = this.schemaResolver.getModelSubpackage(ref).orElse(null);
                    typeInfo = typeInfo.withAddedNormalImport(this.opts.getModelPackage(modelSubpackage) + "." + typeInfo.name());
                    if (!this.schemaResolver.isEnumType(schema.get$ref())) {
                        AnnotationInfo validAnnotation = this.getValidAnnotation();
                        typeInfo = typeInfo.withAddedAnnotation(validAnnotation);
                    }
                    if (!nullable) {
                        AnnotationInfo notNullAnnotation = this.getNotNullAnnotation();
                        typeInfo = typeInfo.withAddedAnnotation(notNullAnnotation);
                    }
                }
                if (StringHelper.nonBlank((String)schema.getDescription())) {
                    typeInfo = typeInfo.withDescription(schema.getDescription());
                }
                return typeInfo;
            }
            if (CollectionHelper.isEmpty((Collection)schema.getAllOf())) {
                throw new IllegalStateException("No types, no ref: %s".formatted(schema.toString()));
            }
        }
        return this.getJsonType(schema, nullabilityResolution);
    }

    public Optional<Schema<?>> getNonNullableSubSchema(List<Schema<?>> subSchemas) {
        return subSchemas.stream().filter(subSchema -> !this.isNullable((Schema<?>)subSchema)).findFirst();
    }

    private TypeInfo getJsonType(Schema<?> schema, NullabilityResolution nullabilityResolution) {
        Optional<String> maybeValidationConstraint;
        TypeInfo typeInfo = new TypeInfo().withDescription(schema.getDescription()).withPrimitive(true).withNullable(this.isNullable(schema, nullabilityResolution));
        String jsonType = StreamHelper.streamSafely((Iterable)schema.getTypes()).filter(t -> !"null".equals(t)).findFirst().orElseThrow(Exceptions.illegalStateException((String)"Unexpected types: %s", (Object[])new Object[]{schema.toString()}));
        if ("string".equals(jsonType)) {
            typeInfo = this.populateJsonStringType(typeInfo, schema);
        } else if ("number".equals(jsonType)) {
            typeInfo = this.populateJsonNumberType(typeInfo, schema);
        } else if ("integer".equals(jsonType)) {
            typeInfo = this.populateJsonIntegerType(typeInfo, schema);
        } else if ("boolean".equals(jsonType)) {
            typeInfo = this.populateJsonBooleanType(typeInfo);
        } else if ("array".equals(jsonType)) {
            typeInfo = this.populateJsonArrayType(typeInfo, schema);
        } else if ("object".equals(jsonType) && schema.getAdditionalProperties() instanceof Schema) {
            typeInfo = this.populateJsonMapType(typeInfo, schema);
        } else {
            throw new IllegalStateException("Unexpected schema: %s".formatted(schema.toString()));
        }
        Optional<String> maybeJsonSerializer = Extensions.extensions(schema.getExtensions()).getString("x-json-serializer");
        if (maybeJsonSerializer.isPresent()) {
            AnnotationInfo jsonSerializeAnnotation = this.getJsonSerializeAnnotation(maybeJsonSerializer.get());
            typeInfo = typeInfo.withAddedAnnotation(jsonSerializeAnnotation);
        }
        if ((maybeValidationConstraint = Extensions.extensions(schema.getExtensions()).getString("x-validation-constraint")).isPresent()) {
            AnnotationInfo validationConstraintAnnotation = new AnnotationInfo("@%s".formatted(StringUtils.getClassNameFromFqn(maybeValidationConstraint.get())), maybeValidationConstraint.get());
            typeInfo = typeInfo.withAddedAnnotation(validationConstraintAnnotation);
        }
        return typeInfo;
    }

    private TypeInfo populateJsonStringType(TypeInfo typeInfo, Schema<?> schema) {
        if ("uri".equals(schema.getFormat())) {
            if (!(typeInfo = typeInfo.withName("URI").withSchemaFormat(schema.getFormat()).withAddedNormalImport("java.net.URI")).nullable()) {
                AnnotationInfo notNullAnnotation = this.getNotNullAnnotation();
                typeInfo = typeInfo.withAddedAnnotation(notNullAnnotation);
            }
        } else if ("uuid".equals(schema.getFormat())) {
            if (!(typeInfo = typeInfo.withName("UUID").withSchemaFormat(schema.getFormat()).withAddedNormalImport("java.util.UUID")).nullable()) {
                AnnotationInfo notNullAnnotation = this.getNotNullAnnotation();
                typeInfo = typeInfo.withAddedAnnotation(notNullAnnotation);
            }
        } else if ("duration".equals(schema.getFormat())) {
            if (!(typeInfo = typeInfo.withName("Duration").withSchemaFormat(schema.getFormat()).withAddedNormalImport("java.time.Duration")).nullable() && this.opts.addJakartaBeanValidationAnnotations()) {
                AnnotationInfo notNullAnnotation = this.getNotNullAnnotation();
                typeInfo = typeInfo.withAddedAnnotation(notNullAnnotation);
            }
        } else if ("date".equals(schema.getFormat())) {
            if (!(typeInfo = typeInfo.withName("LocalDate").withSchemaFormat(schema.getFormat()).withAddedNormalImport("java.time.LocalDate")).nullable() && this.opts.addJakartaBeanValidationAnnotations()) {
                AnnotationInfo notNullAnnotation = this.getNotNullAnnotation();
                typeInfo = typeInfo.withAddedAnnotation(notNullAnnotation);
            }
            AnnotationInfo jsonFormatAnnotation = this.getJsonFormatAnnotation("yyyy-MM-dd");
            typeInfo = typeInfo.withAddedAnnotation(jsonFormatAnnotation);
        } else if ("date-time".equals(schema.getFormat())) {
            if (!(typeInfo = typeInfo.withName("LocalDateTime").withSchemaFormat(schema.getFormat()).withAddedNormalImport("java.time.LocalDateTime")).nullable() && this.opts.addJakartaBeanValidationAnnotations()) {
                AnnotationInfo notNullAnnotation = this.getNotNullAnnotation();
                typeInfo = typeInfo.withAddedAnnotation(notNullAnnotation);
            }
            AnnotationInfo jsonFormatAnnotation = this.getJsonFormatAnnotation("yyyy-MM-dd'T'HH:mm:ss");
            typeInfo = typeInfo.withAddedAnnotation(jsonFormatAnnotation);
        } else if ("email".equals(schema.getFormat())) {
            typeInfo = typeInfo.withName("String").withSchemaFormat(schema.getFormat());
            if (this.opts.addJakartaBeanValidationAnnotations()) {
                if (!typeInfo.nullable()) {
                    AnnotationInfo notBlankAnnotation = this.getNotBlankAnnotation();
                    typeInfo = typeInfo.withAddedAnnotation(notBlankAnnotation);
                }
                AnnotationInfo emailAnnotation = this.getEmailAnnotation();
                typeInfo = typeInfo.withAddedAnnotation(emailAnnotation);
            }
        } else if ("binary".equals(schema.getFormat())) {
            typeInfo = typeInfo.withName("byte[]").withSchemaFormat(schema.getFormat());
            if (this.opts.addJakartaBeanValidationAnnotations()) {
                if (!typeInfo.nullable()) {
                    AnnotationInfo notEmptyAnnotation = this.getNotEmptyAnnotation();
                    typeInfo = typeInfo.withAddedAnnotation(notEmptyAnnotation);
                }
                if (Objects.nonNull(schema.getMinItems()) || Objects.nonNull(schema.getMaxItems())) {
                    AnnotationInfo sizeAnnotaion = this.getArraySizeAnnotation(schema);
                    typeInfo = typeInfo.withAddedAnnotation(sizeAnnotaion);
                }
            }
        } else {
            typeInfo = typeInfo.withName("String").withSchemaFormat(schema.getFormat());
            if (this.opts.addJakartaBeanValidationAnnotations()) {
                if (!typeInfo.nullable()) {
                    AnnotationInfo notBlankAnnotation = this.getNotBlankAnnotation();
                    typeInfo = typeInfo.withAddedAnnotation(notBlankAnnotation);
                }
                if (StringHelper.nonBlank((String)schema.getPattern())) {
                    typeInfo = typeInfo.withSchemaPattern(schema.getPattern()).withAddedAnnotation(this.getPatternAnnotation(schema));
                }
                if (Objects.nonNull(schema.getMinLength()) || Objects.nonNull(schema.getMaxLength())) {
                    AnnotationInfo sizeAnnotation = this.getStringSizeAnnotation(schema);
                    typeInfo = typeInfo.withAddedAnnotation(sizeAnnotation);
                }
            }
        }
        return typeInfo;
    }

    private TypeInfo populateJsonNumberType(TypeInfo typeInfo, Schema<?> schema) {
        typeInfo = "double".equals(schema.getFormat()) ? typeInfo.withName("Double") : ("float".equals(schema.getFormat()) ? typeInfo.withName("Float") : typeInfo.withName("BigDecimal").withAddedNormalImport("java.math.BigDecimal"));
        typeInfo = typeInfo.withSchemaFormat(schema.getFormat());
        if (this.opts.addJakartaBeanValidationAnnotations()) {
            if (!typeInfo.nullable()) {
                AnnotationInfo notNullAnnotation = this.getNotNullAnnotation();
                typeInfo = typeInfo.withAddedAnnotation(notNullAnnotation);
            }
            if ("BigDecimal".equals(typeInfo.name())) {
                if (Objects.nonNull(schema.getMinimum())) {
                    AnnotationInfo minAnnotation = this.getMinAnnotation(schema);
                    typeInfo = typeInfo.withAddedAnnotation(minAnnotation);
                }
                if (Objects.nonNull(schema.getMaximum())) {
                    AnnotationInfo maxAnnotation = this.getMaxAnnotation(schema);
                    typeInfo = typeInfo.withAddedAnnotation(maxAnnotation);
                }
            }
        }
        return typeInfo;
    }

    private TypeInfo populateJsonIntegerType(TypeInfo typeInfo, Schema<?> schema) {
        typeInfo = typeInfo.withName("int64".equals(schema.getFormat()) ? "Long" : "Integer").withSchemaFormat(schema.getFormat());
        if (this.opts.addJakartaBeanValidationAnnotations()) {
            if (!typeInfo.nullable()) {
                AnnotationInfo notNullAnnotation = this.getNotNullAnnotation();
                typeInfo = typeInfo.withAddedAnnotation(notNullAnnotation);
            }
            if (Objects.nonNull(schema.getMinimum())) {
                AnnotationInfo minAnnotation = this.getMinAnnotation(schema);
                typeInfo = typeInfo.withAddedAnnotation(minAnnotation);
            }
            if (Objects.nonNull(schema.getMaximum())) {
                AnnotationInfo maxAnnotation = this.getMaxAnnotation(schema);
                typeInfo = typeInfo.withAddedAnnotation(maxAnnotation);
            }
        }
        return typeInfo;
    }

    private TypeInfo populateJsonBooleanType(TypeInfo typeInfo) {
        if (!(typeInfo = typeInfo.withName("Boolean")).nullable() && this.opts.addJakartaBeanValidationAnnotations()) {
            AnnotationInfo notNullAnnotation = this.getNotNullAnnotation();
            typeInfo = typeInfo.withAddedAnnotation(notNullAnnotation);
        }
        return typeInfo;
    }

    private TypeInfo populateJsonArrayType(TypeInfo typeInfo, Schema<?> schema) {
        typeInfo = typeInfo.withPrimitive(false);
        typeInfo = Boolean.TRUE.equals(schema.getUniqueItems()) ? typeInfo.withName("Set").withAddedNormalImport("java.util.Set") : typeInfo.withName("List").withAddedNormalImport("java.util.List");
        if (this.opts.addJakartaBeanValidationAnnotations()) {
            AnnotationInfo validAnnotation = this.getValidAnnotation();
            typeInfo = typeInfo.withAddedAnnotation(validAnnotation);
        }
        TypeInfo itemType = this.getTypeInfo(schema.getItems());
        if (this.opts.addJakartaBeanValidationAnnotations()) {
            if (!typeInfo.nullable()) {
                AnnotationInfo notNullAnnotation = this.getNotNullAnnotation();
                typeInfo = typeInfo.withAddedAnnotation(notNullAnnotation);
            }
            if (Objects.nonNull(schema.getMinItems()) || Objects.nonNull(schema.getMaxItems())) {
                AnnotationInfo sizeAnnotation = this.getArraySizeAnnotation(schema);
                typeInfo = typeInfo.withAddedAnnotation(sizeAnnotation);
            }
        }
        return typeInfo.withItemType(itemType);
    }

    private TypeInfo populateJsonMapType(TypeInfo typeInfo, Schema<?> schema) {
        typeInfo = typeInfo.withName("Map").withAddedNormalImport("java.util.Map");
        if (this.opts.addJakartaBeanValidationAnnotations()) {
            AnnotationInfo validAnnotation = this.getValidAnnotation();
            typeInfo = typeInfo.withAddedAnnotation(validAnnotation);
        }
        typeInfo = typeInfo.withKeyType(this.getTypeInfo((Schema)new StringSchema())).withItemType(this.getTypeInfo((Schema)schema.getAdditionalProperties()));
        if (this.opts.addJakartaBeanValidationAnnotations()) {
            if (!typeInfo.nullable()) {
                AnnotationInfo notNullAnnotation = this.getNotNullAnnotation();
                typeInfo = typeInfo.withAddedAnnotation(notNullAnnotation);
            }
            if (Objects.nonNull(schema.getMinItems()) || Objects.nonNull(schema.getMaxItems())) {
                AnnotationInfo sizeAnnotation = this.getArraySizeAnnotation(schema);
                typeInfo = typeInfo.withAddedAnnotation(sizeAnnotation);
            }
        }
        return typeInfo;
    }

    private boolean isNullable(Schema<?> schema, NullabilityResolution resolution) {
        return switch (resolution.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.isNullable(schema);
            case 1 -> true;
            case 2 -> false;
        };
    }

    public boolean isNullable(Schema<?> schema) {
        if (CollectionHelper.isEmpty((Collection)schema.getTypes())) {
            if (CollectionHelper.nonEmpty((Collection)schema.getAllOf())) {
                return schema.getAllOf().stream().allMatch(this::isNullable);
            }
            if (CollectionHelper.nonEmpty((Collection)schema.getOneOf())) {
                return schema.getOneOf().stream().anyMatch(this::isNullable);
            }
            if (StringHelper.nonBlank((String)schema.get$ref())) {
                return this.isNullableByExtension(schema);
            }
            throw new IllegalStateException("No types, no ref: %s".formatted(schema.toString()));
        }
        return schema.getTypes().contains("null") || Boolean.TRUE.equals(schema.getNullable()) || this.isNullableByExtension(schema);
    }

    private boolean isNullableByExtension(Schema<?> schema) {
        return Extensions.extensions(schema.getExtensions()).getBoolean("x-nullable").orElse(false);
    }

    private AnnotationInfo getJsonSerializeAnnotation(String jsonSerializer) {
        return new AnnotationInfo("@JsonSerialize(using = %s)".formatted(this.getJsonSerializerClass(jsonSerializer))).withAddedNormalImport("com.fasterxml.jackson.databind.annotation.JsonSerialize").withAddedNormalImport(jsonSerializer);
    }

    private AnnotationInfo getJsonFormatAnnotation(String pattern) {
        return new AnnotationInfo("@JsonFormat(pattern = \"%s\")".formatted(pattern), "com.fasterxml.jackson.annotation.JsonFormat");
    }

    private AnnotationInfo getValidAnnotation() {
        return new AnnotationInfo("@Valid", "jakarta.validation.Valid");
    }

    private AnnotationInfo getNotNullAnnotation() {
        return new AnnotationInfo("@NotNull", "jakarta.validation.constraints.NotNull");
    }

    private AnnotationInfo getNotBlankAnnotation() {
        return new AnnotationInfo("@NotBlank", "jakarta.validation.constraints.NotBlank");
    }

    private AnnotationInfo getNotEmptyAnnotation() {
        return new AnnotationInfo("@NotEmpty", "jakarta.validation.constraints.NotEmpty");
    }

    private AnnotationInfo getMinAnnotation(Schema<?> schema) {
        return new AnnotationInfo("@Min(%d)".formatted(schema.getMinimum().longValue()), "jakarta.validation.constraints.Min");
    }

    private AnnotationInfo getMaxAnnotation(Schema<?> schema) {
        return new AnnotationInfo("@Max(%d)".formatted(schema.getMaximum().longValue()), "jakarta.validation.constraints.Max");
    }

    private AnnotationInfo getPatternAnnotation(Schema<?> schema) {
        return new AnnotationInfo("@Pattern(regexp = \"%s\")".formatted(schema.getPattern()), "jakarta.validation.constraints.Pattern");
    }

    private AnnotationInfo getEmailAnnotation() {
        return new AnnotationInfo("@Email", "jakarta.validation.constraints.Email");
    }

    private AnnotationInfo getArraySizeAnnotation(Schema<?> schema) {
        ArrayList<String> sizeParams = new ArrayList<String>();
        if (Objects.nonNull(schema.getMinItems())) {
            sizeParams.add("min = %d".formatted(schema.getMinItems()));
        }
        if (Objects.nonNull(schema.getMaxItems())) {
            sizeParams.add("max = %d".formatted(schema.getMaxItems()));
        }
        return new AnnotationInfo("@Size(%s)".formatted(StringUtils.joinCsv(sizeParams)), "jakarta.validation.constraints.Size");
    }

    private AnnotationInfo getStringSizeAnnotation(Schema<?> schema) {
        ArrayList<String> sizeParams = new ArrayList<String>();
        if (Objects.nonNull(schema.getMinLength())) {
            sizeParams.add("min = %d".formatted(schema.getMinLength()));
        }
        if (Objects.nonNull(schema.getMaxLength())) {
            sizeParams.add("max = %d".formatted(schema.getMaxLength()));
        }
        return new AnnotationInfo("@Size(%s)".formatted(StringUtils.joinCsv(sizeParams)), "jakarta.validation.constraints.Size");
    }

    private String getJsonSerializerClass(String jsonSerializerFqn) {
        String className = StringUtils.getClassNameFromFqn(jsonSerializerFqn);
        return this.formatClassRef(className);
    }

    public static enum NullabilityResolution {
        FROM_SCHEMA,
        FORCE_NULLABLE,
        FORCE_NOT_NULLABLE;

    }
}

