/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.model;

import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.EntityInfo;
import io.github.torand.openapi2java.model.ImportInfo;
import io.github.torand.openapi2java.model.ImportsSupplier;
import io.github.torand.openapi2java.model.TypeInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public record MethodParamInfo(String name, ImportInfo imports, List<AnnotationInfo> annotations, TypeInfo type, String comment, boolean nullable, String deprecationMessage) implements EntityInfo,
ImportsSupplier
{
    public MethodParamInfo() {
        this(null, ImportInfo.empty(), Collections.emptyList(), null, null, false, null);
    }

    public MethodParamInfo(String name) {
        this(name, ImportInfo.empty(), Collections.emptyList(), null, null, false, null);
    }

    public MethodParamInfo withName(String name) {
        return new MethodParamInfo(name, this.imports, this.annotations, this.type, this.comment, this.nullable, this.deprecationMessage);
    }

    public MethodParamInfo withType(TypeInfo type) {
        return new MethodParamInfo(this.name, this.imports, this.annotations, type, this.comment, this.nullable, this.deprecationMessage);
    }

    public MethodParamInfo withComment(String comment) {
        return new MethodParamInfo(this.name, this.imports, this.annotations, this.type, comment, this.nullable, this.deprecationMessage);
    }

    public MethodParamInfo withNullable(boolean nullable) {
        return new MethodParamInfo(this.name, this.imports, this.annotations, this.type, this.comment, nullable, this.deprecationMessage);
    }

    public MethodParamInfo withDeprecationMessage(String deprecationMessage) {
        return new MethodParamInfo(this.name, this.imports, this.annotations, this.type, this.comment, this.nullable, deprecationMessage);
    }

    public MethodParamInfo withAddedImports(ImportsSupplier importsSupplier) {
        return new MethodParamInfo(this.name, this.imports.withAddedImports(importsSupplier), this.annotations, this.type, this.comment, this.nullable, this.deprecationMessage);
    }

    public MethodParamInfo withAddedAnnotation(AnnotationInfo annotation) {
        LinkedList<AnnotationInfo> newAnnotations = new LinkedList<AnnotationInfo>(this.annotations);
        newAnnotations.add(annotation);
        return new MethodParamInfo(this.name, this.imports, newAnnotations, this.type, this.comment, this.nullable, this.deprecationMessage);
    }

    public MethodParamInfo withAddedAnnotations(Collection<AnnotationInfo> annotations) {
        MethodParamInfo merged = this;
        for (AnnotationInfo annotation : annotations) {
            merged = merged.withAddedAnnotation(annotation);
        }
        return merged;
    }

    public boolean isDeprecated() {
        return Objects.nonNull(this.deprecationMessage);
    }

    @Override
    public Set<String> aggregatedNormalImports() {
        TreeSet<String> aggregated = new TreeSet<String>();
        aggregated.addAll(this.imports.normalImports());
        this.annotations.stream().map(a -> a.imports().normalImports()).forEach(aggregated::addAll);
        aggregated.addAll(this.type.aggregatedNormalImports());
        return aggregated;
    }

    @Override
    public Set<String> aggregatedStaticImports() {
        TreeSet<String> aggregated = new TreeSet<String>();
        aggregated.addAll(this.imports.staticImports());
        this.annotations.stream().map(a -> a.imports().staticImports()).forEach(aggregated::addAll);
        aggregated.addAll(this.type.aggregatedStaticImports());
        return aggregated;
    }
}

