/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.model;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.EntityInfo;
import io.github.torand.openapi2java.model.PropertyInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public record PojoInfo(String name, String modelSubdir, String modelSubpackage, List<AnnotationInfo> annotations, List<PropertyInfo> properties, String deprecationMessage) implements EntityInfo
{
    public PojoInfo(String name) {
        this(name, null, null, Collections.emptyList(), Collections.emptyList(), null);
    }

    public PojoInfo withModelSubdir(String modelSubdir) {
        return new PojoInfo(this.name, modelSubdir, this.modelSubpackage, this.annotations, this.properties, this.deprecationMessage);
    }

    public PojoInfo withModelSubpackage(String modelSubpackage) {
        return new PojoInfo(this.name, modelSubpackage, modelSubpackage, this.annotations, this.properties, this.deprecationMessage);
    }

    public PojoInfo withAddedAnnotation(AnnotationInfo annotation) {
        LinkedList<AnnotationInfo> newAnnotations = new LinkedList<AnnotationInfo>(this.annotations);
        newAnnotations.add(annotation);
        return new PojoInfo(this.name, this.modelSubpackage, this.modelSubpackage, newAnnotations, this.properties, this.deprecationMessage);
    }

    public PojoInfo withAddedProperties(Collection<PropertyInfo> properties) {
        LinkedList<PropertyInfo> newProperties = new LinkedList<PropertyInfo>(this.properties);
        newProperties.addAll(properties);
        return new PojoInfo(this.name, this.modelSubpackage, this.modelSubpackage, this.annotations, newProperties, this.deprecationMessage);
    }

    public PojoInfo withDeprecationMessage(String deprecationMessage) {
        return new PojoInfo(this.name, this.modelSubpackage, this.modelSubpackage, this.annotations, this.properties, deprecationMessage);
    }

    public boolean isDeprecated() {
        return Objects.nonNull(this.deprecationMessage);
    }

    public boolean isEmpty() {
        return CollectionHelper.isEmpty(this.properties);
    }

    @Override
    public Set<String> aggregatedNormalImports() {
        TreeSet<String> aggregated = new TreeSet<String>();
        this.properties.stream().map(p -> p.aggregatedNormalImports()).forEach(aggregated::addAll);
        this.annotations.stream().map(a -> a.imports().normalImports()).forEach(aggregated::addAll);
        return aggregated;
    }

    @Override
    public Set<String> aggregatedStaticImports() {
        TreeSet<String> aggregated = new TreeSet<String>();
        this.properties.stream().map(p -> p.aggregatedStaticImports()).forEach(aggregated::addAll);
        this.annotations.stream().map(a -> a.imports().staticImports()).forEach(aggregated::addAll);
        return aggregated;
    }
}

