/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.model;

import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.EntityInfo;
import io.github.torand.openapi2java.model.TypeInfo;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public record PropertyInfo(String name, TypeInfo type, boolean required, List<AnnotationInfo> annotations, String deprecationMessage) implements EntityInfo
{
    public PropertyInfo(String name) {
        this(name, null, false, Collections.emptyList(), null);
    }

    public PropertyInfo withType(TypeInfo type) {
        return new PropertyInfo(this.name, type, this.required, this.annotations, this.deprecationMessage);
    }

    public PropertyInfo withRequired(boolean required) {
        return new PropertyInfo(this.name, this.type, required, this.annotations, this.deprecationMessage);
    }

    public PropertyInfo withAddedAnnotation(AnnotationInfo annotation) {
        LinkedList<AnnotationInfo> newAnnotations = new LinkedList<AnnotationInfo>(this.annotations);
        newAnnotations.add(annotation);
        return new PropertyInfo(this.name, this.type, this.required, newAnnotations, this.deprecationMessage);
    }

    public PropertyInfo withDeprecationMessage(String deprecationMessage) {
        return new PropertyInfo(this.name, this.type, this.required, this.annotations, deprecationMessage);
    }

    public boolean isDeprecated() {
        return Objects.nonNull(this.deprecationMessage);
    }

    @Override
    public Set<String> aggregatedNormalImports() {
        TreeSet<String> aggregated = new TreeSet<String>(this.type.aggregatedNormalImports());
        this.annotations.stream().map(a -> a.imports().normalImports()).forEach(aggregated::addAll);
        return aggregated;
    }

    @Override
    public Set<String> aggregatedStaticImports() {
        TreeSet<String> aggregated = new TreeSet<String>(this.type.aggregatedStaticImports());
        this.annotations.stream().map(a -> a.imports().staticImports()).forEach(aggregated::addAll);
        return aggregated;
    }
}

