/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.model;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.EntityInfo;
import io.github.torand.openapi2java.model.ImportInfo;
import io.github.torand.openapi2java.model.ImportsSupplier;
import io.github.torand.openapi2java.model.MethodInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public record ResourceInfo(String name, ImportInfo imports, List<AnnotationInfo> annotations, List<MethodInfo> methods) implements EntityInfo,
ImportsSupplier
{
    public ResourceInfo(String name) {
        this(name, ImportInfo.empty(), Collections.emptyList(), Collections.emptyList());
    }

    public ResourceInfo withAddedNormalImport(String normalImport) {
        return new ResourceInfo(this.name, this.imports.withAddedNormalImport(normalImport), this.annotations, this.methods);
    }

    public ResourceInfo withAddedAnnotation(AnnotationInfo annotation) {
        LinkedList<AnnotationInfo> newAnnotations = new LinkedList<AnnotationInfo>(this.annotations);
        newAnnotations.add(annotation);
        return new ResourceInfo(this.name, this.imports, newAnnotations, this.methods);
    }

    public ResourceInfo withAddedAnnotations(Collection<AnnotationInfo> annotations) {
        LinkedList<AnnotationInfo> newAnnotations = new LinkedList<AnnotationInfo>(this.annotations);
        newAnnotations.addAll(annotations);
        return new ResourceInfo(this.name, this.imports, newAnnotations, this.methods);
    }

    public ResourceInfo withAddedMethod(MethodInfo method) {
        LinkedList<MethodInfo> newMethods = new LinkedList<MethodInfo>(this.methods);
        newMethods.add(method);
        return new ResourceInfo(this.name, this.imports, this.annotations, newMethods);
    }

    public boolean isEmpty() {
        return CollectionHelper.isEmpty(this.methods);
    }

    @Override
    public Set<String> aggregatedNormalImports() {
        TreeSet<String> aggregated = new TreeSet<String>();
        aggregated.addAll(this.imports.normalImports());
        this.methods.stream().map(p -> p.aggregatedNormalImports()).forEach(aggregated::addAll);
        this.annotations.stream().map(a -> a.imports().normalImports()).forEach(aggregated::addAll);
        return aggregated;
    }

    @Override
    public Set<String> aggregatedStaticImports() {
        TreeSet<String> aggregated = new TreeSet<String>();
        aggregated.addAll(this.imports.staticImports());
        this.methods.stream().map(p -> p.aggregatedStaticImports()).forEach(aggregated::addAll);
        this.annotations.stream().map(a -> a.imports().staticImports()).forEach(aggregated::addAll);
        return aggregated;
    }
}

