/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.writers.java;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.AnnotatedTypeName;
import io.github.torand.openapi2java.model.PojoInfo;
import io.github.torand.openapi2java.model.PropertyInfo;
import io.github.torand.openapi2java.writers.BaseWriter;
import io.github.torand.openapi2java.writers.PojoWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class JavaPojoWriter
extends BaseWriter
implements PojoWriter {
    public JavaPojoWriter(Writer writer, Options opts) {
        super(writer, opts);
    }

    @Override
    public void write(PojoInfo pojoInfo) {
        this.writeLine("package %s;", this.opts.getModelPackage(pojoInfo.modelSubpackage()));
        this.writeNewLine();
        this.writeNonJavaImports(pojoInfo);
        this.writeJavaImports(pojoInfo);
        if (pojoInfo.isDeprecated()) {
            this.writeLine("/// @deprecated %s".formatted(pojoInfo.deprecationMessage()), new Object[0]);
            this.writeLine("@Deprecated", new Object[0]);
        }
        pojoInfo.annotations().forEach(a -> this.writeLine(a.annotation(), new Object[0]));
        if (this.opts.pojosAsRecords()) {
            this.writeLine("public record %s (".formatted(pojoInfo.name()), new Object[0]);
        } else {
            this.writeLine("public class %s {".formatted(pojoInfo.name()), new Object[0]);
        }
        AtomicInteger propNo = new AtomicInteger(1);
        pojoInfo.properties().forEach(propInfo -> {
            this.writeNewLine();
            this.writePropertyAnnotationLines((PropertyInfo)propInfo);
            this.writePropertyTypeAndNameLines((PropertyInfo)propInfo);
            if (this.opts.pojosAsRecords()) {
                if (propNo.getAndIncrement() < pojoInfo.properties().size()) {
                    this.writeLine(",", new Object[0]);
                } else {
                    this.writeNewLine();
                }
            } else {
                this.writeLine(";", new Object[0]);
            }
        });
        if (this.opts.pojosAsRecords()) {
            this.writeLine(") {", new Object[0]);
            this.writeNewLine();
            this.writeLine("}", new Object[0]);
        } else {
            this.writeNewLine();
            this.writeNoArgConstructor(pojoInfo.name());
            this.writeNewLine();
            this.writeParameterizedConstructor(pojoInfo.name(), pojoInfo.properties());
            this.writeLine("}", new Object[0]);
        }
    }

    private void writeJavaImports(PojoInfo pojoInfo) {
        List<String> imports = pojoInfo.aggregatedNormalImports().stream().filter(this::isJavaPackage).map(arg_0 -> JavaPojoWriter.lambda$writeJavaImports$2("import %s;", arg_0)).toList();
        if (CollectionHelper.nonEmpty(imports)) {
            imports.forEach(x$0 -> this.writeLine((String)x$0, new Object[0]));
            this.writeNewLine();
        }
    }

    private void writeNonJavaImports(PojoInfo pojoInfo) {
        List<String> imports = pojoInfo.aggregatedNormalImports().stream().filter(Predicate.not(this::isJavaPackage)).filter(ni -> !this.isInPackage((String)ni, pojoInfo.modelSubpackage())).map(arg_0 -> JavaPojoWriter.lambda$writeNonJavaImports$5("import %s;", arg_0)).toList();
        if (CollectionHelper.nonEmpty(imports)) {
            imports.forEach(x$0 -> this.writeLine((String)x$0, new Object[0]));
            this.writeNewLine();
        }
    }

    private void writeNoArgConstructor(String name) {
        this.writeIndent(1);
        this.writeLine("public %s() {", name);
        this.writeIndent(1);
        this.writeLine("}", new Object[0]);
    }

    private void writeParameterizedConstructor(String name, List<PropertyInfo> props) {
        this.writeIndent(1);
        this.writeLine("public %s(%s) {", name, props.stream().map(p -> p.type().getFullName() + " " + p.name()).collect(Collectors.joining(", ")));
        props.forEach(p -> {
            this.writeIndent(2);
            this.writeLine("this.%s = %s;", p.name(), p.name());
        });
        this.writeIndent(1);
        this.writeLine("}", new Object[0]);
    }

    private void writePropertyAnnotationLines(PropertyInfo propInfo) {
        if (propInfo.isDeprecated()) {
            this.writeIndent(1);
            this.writeLine("/// @deprecated %s".formatted(propInfo.deprecationMessage()), new Object[0]);
            this.writeIndent(1);
            this.writeLine("@Deprecated", new Object[0]);
        }
        propInfo.annotations().forEach(a -> {
            this.writeIndent(1);
            this.writeLine(a.annotation(), new Object[0]);
        });
    }

    private void writePropertyTypeAndNameLines(PropertyInfo propInfo) {
        AnnotatedTypeName annotatedTypeName = propInfo.type().getAnnotatedFullName();
        annotatedTypeName.annotations().forEach(a -> {
            this.writeIndent(1);
            this.writeLine((String)a, new Object[0]);
        });
        this.writeIndent(1);
        if (this.opts.pojosAsRecords()) {
            this.write("%s %s".formatted(annotatedTypeName.typeName(), propInfo.name()), new Object[0]);
        } else {
            this.write("public %s %s".formatted(annotatedTypeName.typeName(), propInfo.name()), new Object[0]);
        }
    }

    private boolean isInPackage(String qualifiedType, String pojoModelSubpackage) {
        int lastDotIdx = qualifiedType.lastIndexOf(".");
        String typePackage = qualifiedType.substring(0, lastDotIdx);
        return this.opts.getModelPackage(pojoModelSubpackage).equals(typePackage);
    }

    private boolean isJavaPackage(String qualifiedType) {
        return qualifiedType.startsWith("java.");
    }

    private static /* synthetic */ String lambda$writeNonJavaImports$5(String rec$, Object xva$0) {
        return "import %s;".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$writeJavaImports$2(String rec$, Object xva$0) {
        return "import %s;".formatted(xva$0);
    }
}

