/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.writers.java;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.javacommons.stream.StreamHelper;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.MethodParamInfo;
import io.github.torand.openapi2java.model.ResourceInfo;
import io.github.torand.openapi2java.writers.BaseWriter;
import io.github.torand.openapi2java.writers.ResourceWriter;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class JavaResourceWriter
extends BaseWriter
implements ResourceWriter {
    public JavaResourceWriter(Writer writer, Options opts) {
        super(writer, opts);
    }

    @Override
    public void write(ResourceInfo resourceInfo) {
        this.writeLine("package %s;", this.opts.rootPackage());
        this.writeNewLine();
        this.writeNonJavaImports(resourceInfo);
        this.writeJavaImports(resourceInfo);
        this.writeStaticImports(resourceInfo);
        resourceInfo.annotations().forEach(a -> this.writeLine(a.annotation(), new Object[0]));
        this.writeLine("public interface %s {".formatted(resourceInfo.name()), new Object[0]);
        this.writeNewLine();
        this.writeIndent(1);
        this.writeLine("String ROOT_PATH = \"%s\";", this.opts.rootUrlPath());
        resourceInfo.methods().forEach(m -> {
            this.writeNewLine();
            if (m.isDeprecated()) {
                this.writeIndent(1);
                this.writeLine("/// @deprecated %s".formatted(m.deprecationMessage()), new Object[0]);
                this.writeIndent(1);
                this.writeLine("@Deprecated", new Object[0]);
            }
            m.annotations().forEach(a -> {
                this.writeIndent(1);
                this.writeLine(a.annotation(), new Object[0]);
            });
            this.writeIndent(1);
            if (this.opts.useResteasyResponse()) {
                this.writeLine("RestResponse<%s> %s(".formatted(Objects.nonNull(m.returnType()) ? m.returnType() : "Void", m.name()), new Object[0]);
            } else {
                this.writeLine("Response %s(".formatted(m.name()), new Object[0]);
            }
            for (int i = 0; i < m.parameters().size(); ++i) {
                MethodParamInfo paramInfo = m.parameters().get(i);
                this.writeIndent(2);
                if (paramInfo.isDeprecated()) {
                    this.write("@Deprecated ", new Object[0]);
                }
                if (CollectionHelper.nonEmpty(paramInfo.annotations())) {
                    this.write(String.join((CharSequence)" ", StreamHelper.streamSafely(paramInfo.annotations()).map(AnnotationInfo::annotation).toList()) + " ", new Object[0]);
                }
                this.write(paramInfo.type().getAnnotatedFullName().asString() + " ", new Object[0]);
                this.write(paramInfo.name(), new Object[0]);
                if (i < m.parameters().size() - 1) {
                    this.write(",", new Object[0]);
                }
                if (StringHelper.nonBlank((String)paramInfo.comment())) {
                    this.write(" // %s", paramInfo.comment());
                }
                this.writeNewLine();
            }
            this.writeIndent(1);
            this.writeLine(");", new Object[0]);
        });
        this.writeLine("}", new Object[0]);
    }

    private void writeJavaImports(ResourceInfo resourceInfo) {
        List<String> imports = resourceInfo.aggregatedNormalImports().stream().filter(this::isJavaPackage).map(arg_0 -> JavaResourceWriter.lambda$writeJavaImports$3("import %s;", arg_0)).toList();
        if (CollectionHelper.nonEmpty(imports)) {
            imports.forEach(x$0 -> this.writeLine((String)x$0, new Object[0]));
            this.writeNewLine();
        }
    }

    private void writeNonJavaImports(ResourceInfo resourceInfo) {
        List<String> imports = resourceInfo.aggregatedNormalImports().stream().filter(Predicate.not(this::isJavaPackage)).map(arg_0 -> JavaResourceWriter.lambda$writeNonJavaImports$5("import %s;", arg_0)).toList();
        if (CollectionHelper.nonEmpty(imports)) {
            imports.forEach(x$0 -> this.writeLine((String)x$0, new Object[0]));
            this.writeNewLine();
        }
    }

    private void writeStaticImports(ResourceInfo resourceInfo) {
        List<String> imports = resourceInfo.aggregatedStaticImports().stream().map(arg_0 -> JavaResourceWriter.lambda$writeStaticImports$7("import static %s;", arg_0)).toList();
        if (CollectionHelper.nonEmpty(imports)) {
            imports.forEach(x$0 -> this.writeLine((String)x$0, new Object[0]));
            this.writeNewLine();
        }
    }

    private boolean isJavaPackage(String qualifiedType) {
        return qualifiedType.startsWith("java.");
    }

    private static /* synthetic */ String lambda$writeStaticImports$7(String rec$, Object xva$0) {
        return "import static %s;".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$writeNonJavaImports$5(String rec$, Object xva$0) {
        return "import %s;".formatted(xva$0);
    }

    private static /* synthetic */ String lambda$writeJavaImports$3(String rec$, Object xva$0) {
        return "import %s;".formatted(xva$0);
    }
}

