/*
 * Decompiled with CFR 0.152.
 */
package io.github.torand.openapi2java.writers.kotlin;

import io.github.torand.javacommons.collection.CollectionHelper;
import io.github.torand.javacommons.lang.StringHelper;
import io.github.torand.javacommons.stream.StreamHelper;
import io.github.torand.openapi2java.generators.Options;
import io.github.torand.openapi2java.model.AnnotatedTypeName;
import io.github.torand.openapi2java.model.AnnotationInfo;
import io.github.torand.openapi2java.model.MethodParamInfo;
import io.github.torand.openapi2java.model.ResourceInfo;
import io.github.torand.openapi2java.utils.KotlinTypeMapper;
import io.github.torand.openapi2java.writers.BaseWriter;
import io.github.torand.openapi2java.writers.ResourceWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class KotlinResourceWriter
extends BaseWriter
implements ResourceWriter {
    public KotlinResourceWriter(Writer writer, Options opts) {
        super(writer, opts);
    }

    @Override
    public void write(ResourceInfo resourceInfo) {
        this.writeLine("package %s", this.opts.rootPackage());
        this.writeNewLine();
        this.writeImports(resourceInfo);
        resourceInfo.annotations().forEach(a -> this.writeLine(a.annotation(), new Object[0]));
        this.writeLine("interface %s {".formatted(resourceInfo.name()), new Object[0]);
        resourceInfo.methods().forEach(m -> {
            this.writeNewLine();
            if (m.isDeprecated()) {
                this.writeIndent(1);
                this.writeLine("@Deprecated(\"%s\")".formatted(m.deprecationMessage()), new Object[0]);
            }
            m.annotations().forEach(a -> {
                this.writeIndent(1);
                this.writeLine(a.annotation(), new Object[0]);
            });
            this.writeIndent(1);
            this.writeLine("fun %s(".formatted(m.name()), new Object[0]);
            for (int i = 0; i < m.parameters().size(); ++i) {
                AnnotatedTypeName annotatedTypeName;
                MethodParamInfo paramInfo = m.parameters().get(i);
                this.writeIndent(2);
                if (CollectionHelper.nonEmpty(paramInfo.annotations())) {
                    this.write(String.join((CharSequence)" ", StreamHelper.streamSafely(paramInfo.annotations()).map(AnnotationInfo::annotation).toList()) + " ", new Object[0]);
                }
                if ((annotatedTypeName = paramInfo.type().getAnnotatedFullName()).hasAnnotations()) {
                    this.write(annotatedTypeName.annotationsAsString() + " ", new Object[0]);
                }
                this.write(paramInfo.name() + ": ", new Object[0]);
                this.write(KotlinTypeMapper.toKotlinNative(annotatedTypeName.typeName()), new Object[0]);
                if (paramInfo.nullable()) {
                    this.write("? = null", new Object[0]);
                }
                if (i < m.parameters().size() - 1) {
                    this.write(",", new Object[0]);
                }
                if (StringHelper.nonBlank((String)paramInfo.comment())) {
                    this.write(" // %s", paramInfo.comment());
                }
                this.writeNewLine();
            }
            this.writeIndent(1);
            if (this.opts.useResteasyResponse()) {
                this.writeLine("): RestResponse<%s>".formatted(Objects.nonNull(m.returnType()) ? m.returnType() : "Unit"), new Object[0]);
            } else {
                this.writeLine("): Response", new Object[0]);
            }
        });
        this.writeNewLine();
        this.writeIndent(1);
        this.writeLine("companion object {", new Object[0]);
        this.writeIndent(2);
        this.writeLine("const val ROOT_PATH: String = \"%s\"", this.opts.rootUrlPath());
        this.writeIndent(1);
        this.writeLine("}", new Object[0]);
        this.writeLine("}", new Object[0]);
    }

    private void writeImports(ResourceInfo resourceInfo) {
        Set imports = resourceInfo.aggregatedImports().stream().filter(Predicate.not("java.util.List"::equals)).filter(Predicate.not("java.util.Map"::equals)).filter(Predicate.not(i -> i.contains("ROOT_PATH"))).map(arg_0 -> KotlinResourceWriter.lambda$writeImports$4("import %s", arg_0)).collect(Collectors.toCollection(TreeSet::new));
        imports.add("import %s.%s.Companion.ROOT_PATH".formatted(this.opts.rootPackage(), resourceInfo.name()));
        imports.forEach(x$0 -> this.writeLine((String)x$0, new Object[0]));
        this.writeNewLine();
    }

    private static /* synthetic */ String lambda$writeImports$4(String rec$, Object xva$0) {
        return "import %s".formatted(xva$0);
    }
}

