/*
 * Decompiled with CFR 0.152.
 */
package com.waas.callbackServer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.waas.callbackServer.dto.withdrawRiskRequest;
import com.waas.callbackServer.dto.withdrawRiskResponse;
import com.waas.callbackServer.serverTool;
import java.io.InputStreamReader;

public class withdrawRiskHandler
implements HttpHandler {
    private serverTool sTool;

    public withdrawRiskHandler(serverTool tool) {
        this.sTool = tool;
    }

    @Override
    public void handle(HttpExchange httpExchange) {
        Gson gson = new GsonBuilder().create();
        withdrawRiskResponse res = new withdrawRiskResponse();
        try {
            withdrawRiskRequest req = this.sTool.getWithdrawRiskRequest(new InputStreamReader(httpExchange.getRequestBody()));
            System.out.println(gson.toJson((Object)req));
            if (!this.sTool.verifySign(req)) {
                res.setStatus(5400);
                this.sTool.writeResponse(httpExchange, res);
                return;
            }
            res.setStatus(200);
            res.getData().setStatus_code(200);
            res.getData().setOrder_id(req.getData().getOrder_id());
            res.getData().setTimestamp(System.currentTimeMillis() / 1000L);
            this.sTool.addSignToResponse(res);
            System.out.println(gson.toJson((Object)res));
            this.sTool.writeResponse(httpExchange, res);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

