/*
 * Decompiled with CFR 0.152.
 */
package com.waas.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.waas.client.apiClientConfig;
import com.waas.client.dto.addressGetBatchRequest;
import com.waas.client.dto.addressGetBatchResponse;
import com.waas.client.dto.addressListRequest;
import com.waas.client.dto.addressListResponse;
import com.waas.client.dto.addressSyncStatusRequest;
import com.waas.client.dto.addressSyncStatusResponse;
import com.waas.client.dto.addressVerifyAddressRequest;
import com.waas.client.dto.addressVerifyAddressResponse;
import com.waas.client.dto.coinListRequest;
import com.waas.client.dto.coinListResponse;
import com.waas.client.dto.iRequest;
import com.waas.client.dto.transferRequest;
import com.waas.client.dto.transferResponse;
import com.waas.client.iApiClient;
import com.waas.crypto.rsaSigner;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class defaultApiClient
implements iApiClient {
    private HttpClient httpClient;
    private final apiClientConfig config;
    private final Gson gson;

    public defaultApiClient(apiClientConfig config) {
        this(config, HttpClient.newHttpClient());
    }

    public defaultApiClient(apiClientConfig config, HttpClient httpClient) {
        this.httpClient = httpClient;
        this.config = config;
        this.gson = new GsonBuilder().create();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public coinListResponse coinList(coinListRequest request) throws Exception {
        return this.doPost("/coin/list", request, coinListResponse.class);
    }

    @Override
    public addressGetBatchResponse addressGetBatch(addressGetBatchRequest request) throws Exception {
        return this.doPost("/address/getBatch", request, addressGetBatchResponse.class);
    }

    @Override
    public addressSyncStatusResponse addressSyncStatus(addressSyncStatusRequest request) throws Exception {
        return this.doPost("/address/syncStatus", request, addressSyncStatusResponse.class);
    }

    @Override
    public addressListResponse addressList(addressListRequest request) throws Exception {
        return this.doPost("/address/list", request, addressListResponse.class);
    }

    @Override
    public addressVerifyAddressResponse addressVerifyAddress(addressVerifyAddressRequest request) throws Exception {
        return this.doPost("/address/verifyAddress", request, addressVerifyAddressResponse.class);
    }

    @Override
    public transferResponse transfer(transferRequest request) throws Exception {
        return this.doPost("/transfer", request, transferResponse.class);
    }

    private <R> R doPost(String path, iRequest request, Class<R> classOfResponse) throws Exception {
        rsaSigner signer = new rsaSigner();
        request.setApp_id(this.config.appid);
        request.setVersion(this.config.version);
        request.setKey_version(this.config.keyVersion);
        request.setTime(Long.valueOf(System.currentTimeMillis() / 1000L).toString());
        request.setSign(signer.genSign(request, this.config.privateKey));
        HttpRequest hr = HttpRequest.newBuilder().uri(URI.create(this.config.baseUrl + path)).POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson((Object)request))).build();
        System.out.println(this.gson.toJson((Object)request));
        HttpResponse<String> httpResp = this.httpClient.send(hr, HttpResponse.BodyHandlers.ofString());
        if (httpResp.statusCode() != 200) {
            throw new Exception(String.format("http error[%d]: %s", httpResp.statusCode(), httpResp.body()));
        }
        System.out.println(httpResp.body());
        JsonObject jObject = JsonParser.parseString((String)httpResp.body()).getAsJsonObject();
        if (jObject.get("status").getAsInt() == 200) {
            boolean signOk = signer.verifySign((JsonElement)jObject, jObject.get("sign").getAsString(), this.config.platformPublicKey);
            if (!signOk) {
                throw new Exception("response verifySign fail:" + httpResp.body());
            }
        } else if (jObject.get("data").isJsonArray() && jObject.get("data").getAsJsonArray().isEmpty()) {
            jObject.remove("data");
        }
        return (R)this.gson.fromJson((JsonElement)jObject, classOfResponse);
    }
}

