/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.yamlconfiguration.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import jetbrains.annotations.NotNull;
import jetbrains.annotations.Nullable;
import wf.utils.yamlconfiguration.configuration.Configuration;
import wf.utils.yamlconfiguration.configuration.InvalidConfigurationException;
import wf.utils.yamlconfiguration.configuration.MemoryConfiguration;
import wf.utils.yamlconfiguration.file.FileConfigurationOptions;

public abstract class FileConfiguration
extends MemoryConfiguration {
    public FileConfiguration() {
    }

    public FileConfiguration(@Nullable Configuration defs) {
        super(defs);
    }

    public final void save(@NotNull File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("File has not been created at " + file.getPath());
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8.name());){
            writer.write(this.saveToString());
        }
    }

    public final void save(@NotNull String path) throws IOException {
        this.save(new File(path));
    }

    @NotNull
    public abstract String saveToString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@NotNull Reader reader) throws IOException, InvalidConfigurationException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                builder.append(line).append('\n');
            }
        }
        this.loadFromString(builder.toString());
    }

    public final void load(@NotNull File file) throws IOException, InvalidConfigurationException {
        this.load(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8.name()));
    }

    public final void load(@NotNull String path) throws IOException, InvalidConfigurationException {
        this.load(new File(path));
    }

    public abstract void loadFromString(@NotNull String var1) throws InvalidConfigurationException;

    @Deprecated
    @NotNull
    protected final String buildHeader() {
        return "";
    }

    @Override
    @NotNull
    public FileConfigurationOptions getOptions() {
        if (this.options == null) {
            this.options = new FileConfigurationOptions(this);
        }
        return (FileConfigurationOptions)this.options;
    }

    @Override
    @Deprecated
    @NotNull
    public FileConfigurationOptions options() {
        return this.getOptions();
    }
}

