/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.yamlconfiguration.file;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jetbrains.annotations.NotNull;
import jetbrains.annotations.Nullable;
import wf.utils.yamlconfiguration.configuration.MemoryConfiguration;
import wf.utils.yamlconfiguration.configuration.MemoryConfigurationOptions;
import wf.utils.yamlconfiguration.file.FileConfiguration;

public class FileConfigurationOptions
extends MemoryConfigurationOptions {
    private List<String> header = Collections.emptyList();
    private List<String> footer = Collections.emptyList();
    private boolean parseComments = true;

    protected FileConfigurationOptions(@NotNull MemoryConfiguration configuration) {
        super(configuration);
    }

    @Override
    @NotNull
    public FileConfiguration getConfiguration() {
        return (FileConfiguration)super.getConfiguration();
    }

    @Override
    @Deprecated
    @NotNull
    public FileConfiguration configuration() {
        return (FileConfiguration)super.configuration();
    }

    @Override
    @NotNull
    public FileConfigurationOptions setPathSeparator(char pathSeparator) {
        super.setPathSeparator(pathSeparator);
        return this;
    }

    @Override
    @Deprecated
    @NotNull
    public FileConfigurationOptions pathSeparator(char pathSeparator) {
        super.pathSeparator(pathSeparator);
        return this;
    }

    @Override
    @NotNull
    public FileConfigurationOptions setCopyDefaults(boolean copyDefaults) {
        super.setCopyDefaults(copyDefaults);
        return this;
    }

    @Override
    @Deprecated
    @NotNull
    public FileConfigurationOptions copyDefaults(boolean copyDefaults) {
        super.copyDefaults(copyDefaults);
        return this;
    }

    @NotNull
    public final List<String> getHeader() {
        return this.header;
    }

    @Deprecated
    @NotNull
    public final String header() {
        StringBuilder builder = new StringBuilder();
        for (String line : this.header) {
            builder.append(line == null ? "" : line).append("\n");
        }
        return builder.toString();
    }

    @NotNull
    public FileConfigurationOptions setHeader(@Nullable List<String> header) {
        this.header = header == null ? Collections.emptyList() : Collections.unmodifiableList(header);
        return this;
    }

    @Deprecated
    @NotNull
    public FileConfigurationOptions header(@Nullable String header) {
        this.header = header == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(header.split("\\n")));
        return this;
    }

    @NotNull
    public final List<String> getFooter() {
        return this.footer;
    }

    @NotNull
    public FileConfigurationOptions setFooter(@Nullable List<String> footer) {
        this.footer = footer == null ? Collections.emptyList() : Collections.unmodifiableList(footer);
        return this;
    }

    public final boolean getParseComments() {
        return this.parseComments;
    }

    @Deprecated
    public final boolean copyHeader() {
        return this.parseComments;
    }

    @NotNull
    public FileConfigurationOptions setParseComments(boolean parseComments) {
        this.parseComments = parseComments;
        return this;
    }

    @Deprecated
    @NotNull
    public FileConfigurationOptions copyHeader(boolean parseComments) {
        this.parseComments = parseComments;
        return this;
    }
}

