/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.yamlconfiguration.file;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jetbrains.annotations.NotNull;
import jetbrains.annotations.Nullable;
import wf.utils.yamlconfiguration.configuration.Configuration;
import wf.utils.yamlconfiguration.configuration.ConfigurationSection;
import wf.utils.yamlconfiguration.configuration.InvalidConfigurationException;
import wf.utils.yamlconfiguration.file.FileConfiguration;
import wf.utils.yamlconfiguration.file.YamlConfigurationOptions;
import wf.utils.yamlconfiguration.file.YamlConstructor;
import wf.utils.yamlconfiguration.file.YamlRepresenter;
import wf.utils.yamlconfiguration.snakeyaml.DumperOptions;
import wf.utils.yamlconfiguration.snakeyaml.LoaderOptions;
import wf.utils.yamlconfiguration.snakeyaml.Yaml;
import wf.utils.yamlconfiguration.snakeyaml.comments.CommentLine;
import wf.utils.yamlconfiguration.snakeyaml.comments.CommentType;
import wf.utils.yamlconfiguration.snakeyaml.constructor.BaseConstructor;
import wf.utils.yamlconfiguration.snakeyaml.error.YAMLException;
import wf.utils.yamlconfiguration.snakeyaml.nodes.AnchorNode;
import wf.utils.yamlconfiguration.snakeyaml.nodes.MappingNode;
import wf.utils.yamlconfiguration.snakeyaml.nodes.Node;
import wf.utils.yamlconfiguration.snakeyaml.nodes.NodeTuple;
import wf.utils.yamlconfiguration.snakeyaml.nodes.ScalarNode;
import wf.utils.yamlconfiguration.snakeyaml.nodes.SequenceNode;
import wf.utils.yamlconfiguration.snakeyaml.nodes.Tag;
import wf.utils.yamlconfiguration.snakeyaml.reader.UnicodeReader;
import wf.utils.yamlconfiguration.snakeyaml.representer.Representer;

public final class YamlConfiguration
extends FileConfiguration {
    private final YamlConstructor yamlConstructor = new YamlConstructor();
    private final YamlRepresenter yamlRepresenter = new YamlRepresenter();
    private final DumperOptions dumperOptions;
    private final LoaderOptions loaderOptions;
    private final Yaml yaml;

    public YamlConfiguration() {
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.dumperOptions = new DumperOptions();
        this.dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.loaderOptions = new LoaderOptions();
        this.yaml = new Yaml((BaseConstructor)this.yamlConstructor, (Representer)this.yamlRepresenter, this.dumperOptions, this.loaderOptions);
    }

    public YamlConfiguration(@Nullable Configuration defs) {
        super(defs);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.dumperOptions = new DumperOptions();
        this.dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.loaderOptions = new LoaderOptions();
        this.yaml = new Yaml((BaseConstructor)this.yamlConstructor, (Representer)this.yamlRepresenter, this.dumperOptions, this.loaderOptions);
    }

    @Override
    @NotNull
    public String saveToString() {
        this.dumperOptions.setIndent(this.getOptions().getIndent());
        this.dumperOptions.setWidth(this.getOptions().getWidth());
        this.dumperOptions.setProcessComments(this.getOptions().getParseComments());
        MappingNode mappingNode = this.toNodeTree(this);
        mappingNode.setBlockComments(this.getCommentLines(this.saveHeader(this.getOptions().getHeader()), CommentType.BLOCK));
        mappingNode.setEndComments(this.getCommentLines(this.getOptions().getFooter(), CommentType.BLOCK));
        StringWriter writer = new StringWriter();
        if (mappingNode.getBlockComments().isEmpty() && mappingNode.getEndComments().isEmpty() && mappingNode.getValue().isEmpty()) {
            writer.write("");
        } else {
            if (mappingNode.getValue().isEmpty()) {
                mappingNode.setFlowStyle(DumperOptions.FlowStyle.FLOW);
            }
            this.yaml.serialize(mappingNode, writer);
        }
        return writer.toString();
    }

    @Override
    public void loadFromString(@NotNull String data) throws InvalidConfigurationException {
        MappingNode mappingNode;
        this.loaderOptions.setMaxAliasesForCollections(this.getOptions().getMaxAliases());
        this.loaderOptions.setCodePointLimit(this.getOptions().getCodePointLimit());
        this.loaderOptions.setProcessComments(this.getOptions().getParseComments());
        try (UnicodeReader reader = new UnicodeReader(new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8)));){
            mappingNode = (MappingNode)this.yaml.compose(reader);
        }
        catch (IOException | YAMLException e) {
            throw new InvalidConfigurationException(e);
        }
        catch (ClassCastException e) {
            throw new InvalidConfigurationException("Top level is not a Map.", e);
        }
        this.map.clear();
        if (mappingNode != null) {
            this.adjustNodeComments(mappingNode);
            this.getOptions().setHeader((List)this.loadHeader(this.getCommentLines(mappingNode.getBlockComments())));
            this.getOptions().setFooter((List)this.getCommentLines(mappingNode.getEndComments()));
            this.fromNodeTree(mappingNode, this);
        }
    }

    private void adjustNodeComments(@NotNull MappingNode mappingNode) {
        Node node;
        List<CommentLine> comments;
        if (mappingNode.getBlockComments() == null && !mappingNode.getValue().isEmpty() && (comments = (node = mappingNode.getValue().get(0).getKeyNode()).getBlockComments()) != null) {
            int commentIndex = -1;
            for (int index = 0; index < comments.size(); ++index) {
                if (comments.get(index).getCommentType() != CommentType.BLANK_LINE) continue;
                commentIndex = index;
            }
            if (commentIndex != -1) {
                mappingNode.setBlockComments(comments.subList(0, commentIndex + 1));
                node.setBlockComments(comments.subList(commentIndex + 1, comments.size()));
            }
        }
    }

    private void fromNodeTree(@NotNull MappingNode mappingNode, @NotNull ConfigurationSection section) {
        this.yamlConstructor.flattenMapping(mappingNode);
        for (NodeTuple nodeTuple : mappingNode.getValue()) {
            Node keyNode = nodeTuple.getKeyNode();
            String key = String.valueOf(this.yamlConstructor.construct(keyNode));
            Node valueNode = nodeTuple.getValueNode();
            while (valueNode instanceof AnchorNode) {
                valueNode = ((AnchorNode)valueNode).getRealNode();
            }
            if (valueNode instanceof MappingNode && !this.hasSerializedTypeKey((MappingNode)valueNode)) {
                this.fromNodeTree((MappingNode)valueNode, section.createSection(key));
            } else {
                section.set(key, this.yamlConstructor.construct(valueNode));
            }
            section.setComments(key, this.getCommentLines(keyNode.getBlockComments()));
            if (valueNode instanceof MappingNode || valueNode instanceof SequenceNode) {
                section.setInLineComments(key, this.getCommentLines(keyNode.getInLineComments()));
                continue;
            }
            section.setInLineComments(key, this.getCommentLines(valueNode.getInLineComments()));
        }
    }

    private boolean hasSerializedTypeKey(@NotNull MappingNode mappingNode) {
        for (NodeTuple nodeTuple : mappingNode.getValue()) {
            String key;
            Node keyNode = nodeTuple.getKeyNode();
            if (!(keyNode instanceof ScalarNode) || !(key = ((ScalarNode)keyNode).getValue()).equals("==")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private MappingNode toNodeTree(@NotNull ConfigurationSection section) {
        ArrayList<NodeTuple> nodeTuples = new ArrayList<NodeTuple>();
        for (Map.Entry<String, Object> entry : section.getValues(false).entrySet()) {
            Node keyNode = this.yamlRepresenter.represent(entry.getKey());
            Node valueNode = entry.getValue() instanceof ConfigurationSection ? this.toNodeTree((ConfigurationSection)entry.getValue()) : this.yamlRepresenter.represent(entry.getValue());
            keyNode.setBlockComments(this.getCommentLines(section.getComments(entry.getKey()), CommentType.BLOCK));
            if (valueNode instanceof MappingNode || valueNode instanceof SequenceNode) {
                keyNode.setInLineComments(this.getCommentLines(section.getInLineComments(entry.getKey()), CommentType.IN_LINE));
            } else {
                valueNode.setInLineComments(this.getCommentLines(section.getInLineComments(entry.getKey()), CommentType.IN_LINE));
            }
            nodeTuples.add(new NodeTuple(keyNode, valueNode));
        }
        return new MappingNode(Tag.MAP, nodeTuples, DumperOptions.FlowStyle.BLOCK);
    }

    @NotNull
    private List<String> getCommentLines(@Nullable List<CommentLine> commentLines) {
        ArrayList<String> comments = new ArrayList<String>();
        if (commentLines == null) {
            return comments;
        }
        for (CommentLine commentLine : commentLines) {
            if (commentLine.getCommentType() == CommentType.BLANK_LINE) {
                comments.add(null);
                continue;
            }
            String comment = commentLine.getValue();
            comment = comment.startsWith(" ") ? comment.substring(1) : comment;
            comments.add(comment);
        }
        return comments;
    }

    @NotNull
    private List<CommentLine> getCommentLines(@NotNull List<String> comments, @NotNull CommentType commentType) {
        ArrayList<CommentLine> commentLines = new ArrayList<CommentLine>();
        for (String comment : comments) {
            if (comment == null) {
                commentLines.add(new CommentLine(null, null, "", CommentType.BLANK_LINE));
                continue;
            }
            String line = comment;
            line = line.isEmpty() ? line : " " + line;
            commentLines.add(new CommentLine(null, null, line, commentType));
        }
        return commentLines;
    }

    @NotNull
    private List<String> loadHeader(@NotNull List<String> formattedHeader) {
        LinkedList<String> header = new LinkedList<String>(formattedHeader);
        if (!header.isEmpty()) {
            header.removeLast();
        }
        while (!header.isEmpty() && header.peek() == null) {
            header.remove();
        }
        return header;
    }

    @NotNull
    private List<String> saveHeader(@NotNull List<String> header) {
        LinkedList<String> formattedHeader = new LinkedList<String>(header);
        if (!formattedHeader.isEmpty()) {
            formattedHeader.add(null);
        }
        return formattedHeader;
    }

    @Override
    @NotNull
    public YamlConfigurationOptions getOptions() {
        if (this.options == null) {
            this.options = new YamlConfigurationOptions(this);
        }
        return (YamlConfigurationOptions)this.options;
    }

    @Override
    @Deprecated
    @NotNull
    public YamlConfigurationOptions options() {
        return this.getOptions();
    }

    @NotNull
    public static YamlConfiguration loadConfiguration(@NotNull File file) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (IOException | InvalidConfigurationException e) {
            Logger.getLogger(YamlConfiguration.class.getName()).log(Level.SEVERE, "Cannot load config from file: " + file.getPath(), e);
        }
        return config;
    }

    @NotNull
    public static YamlConfiguration loadConfiguration(@NotNull Reader reader) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(reader);
        }
        catch (IOException | InvalidConfigurationException e) {
            Logger.getLogger(YamlConfiguration.class.getName()).log(Level.SEVERE, "Cannot load config from reader.", e);
        }
        return config;
    }
}

