/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.yamlconfiguration.file;

import java.util.LinkedHashMap;
import java.util.Map;
import jetbrains.annotations.NotNull;
import jetbrains.annotations.Nullable;
import wf.utils.yamlconfiguration.serialization.ConfigurationSerialization;
import wf.utils.yamlconfiguration.snakeyaml.constructor.SafeConstructor;
import wf.utils.yamlconfiguration.snakeyaml.error.YAMLException;
import wf.utils.yamlconfiguration.snakeyaml.nodes.MappingNode;
import wf.utils.yamlconfiguration.snakeyaml.nodes.Node;
import wf.utils.yamlconfiguration.snakeyaml.nodes.Tag;

public final class YamlConstructor
extends SafeConstructor {
    YamlConstructor() {
        this.yamlConstructors.put(Tag.MAP, new ConstructCustomObject());
    }

    @Nullable
    Object construct(@NotNull Node node) {
        return this.constructObject(node);
    }

    @Override
    protected void flattenMapping(@NotNull MappingNode mappingNode) {
        super.flattenMapping(mappingNode);
    }

    private class ConstructCustomObject
    extends SafeConstructor.ConstructYamlMap {
        private ConstructCustomObject() {
            super(YamlConstructor.this);
        }

        @Override
        @Nullable
        public Object construct(@NotNull Node node) {
            if (node.isTwoStepsConstruction()) {
                throw new YAMLException("Unexpected referential mapping structure. Node: " + node);
            }
            Map raw = (Map)super.construct(node);
            if (raw.containsKey("==")) {
                LinkedHashMap typed = new LinkedHashMap(raw.size());
                for (Map.Entry entry : raw.entrySet()) {
                    typed.put(entry.getKey().toString(), entry.getValue());
                }
                try {
                    return ConfigurationSerialization.deserializeObject(typed);
                }
                catch (IllegalArgumentException e) {
                    throw new YAMLException("Could not deserialize object.", e);
                }
            }
            return raw;
        }

        @Override
        public void construct2ndStep(@NotNull Node node, @NotNull Object object) {
            throw new YAMLException("Unexpected referential mapping structure. Node: " + node);
        }
    }
}

