/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.yamlconfiguration.file;

import java.util.LinkedHashMap;
import jetbrains.annotations.NotNull;
import wf.utils.yamlconfiguration.configuration.ConfigurationSection;
import wf.utils.yamlconfiguration.serialization.ConfigurationSerializable;
import wf.utils.yamlconfiguration.serialization.ConfigurationSerialization;
import wf.utils.yamlconfiguration.snakeyaml.nodes.Node;
import wf.utils.yamlconfiguration.snakeyaml.representer.Representer;
import wf.utils.yamlconfiguration.snakeyaml.representer.SafeRepresenter;

public final class YamlRepresenter
extends Representer {
    YamlRepresenter() {
        this.multiRepresenters.put(ConfigurationSection.class, new RepresentConfigurationSection());
        this.multiRepresenters.put(ConfigurationSerializable.class, new RepresentConfigurationSerializable());
        this.multiRepresenters.remove(Enum.class);
    }

    private class RepresentConfigurationSection
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSection() {
            super(YamlRepresenter.this);
        }

        @Override
        @NotNull
        public Node representData(@NotNull Object object) {
            return super.representData(((ConfigurationSection)object).getValues(false));
        }
    }

    private class RepresentConfigurationSerializable
    extends SafeRepresenter.RepresentMap {
        private RepresentConfigurationSerializable() {
            super(YamlRepresenter.this);
        }

        @Override
        @NotNull
        public Node representData(@NotNull Object object) {
            ConfigurationSerializable serializable = (ConfigurationSerializable)object;
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            values.put("==", ConfigurationSerialization.getAlias(serializable.getClass()));
            values.putAll(serializable.serialize());
            return super.representData(values);
        }
    }
}

