/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.yamlconfiguration.utils.types;

import wf.utils.yamlconfiguration.utils.StringSerializable;

public class IntegerInRange
implements StringSerializable<IntegerInRange> {
    private int min;
    private int max;

    public IntegerInRange() {
    }

    public IntegerInRange(int min, int max) {
        if (min > max) {
            int n = min + max;
            max = min;
            min = n - max;
        }
        this.min = min;
        this.max = max;
    }

    public IntegerInRange(String s) {
        this(s.split("\\.\\.")[0].isEmpty() ? Integer.MIN_VALUE : Integer.parseInt(s.split("\\.\\.")[0]), s.split("\\.\\.")[1].isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(s.split("\\.\\.")[1]));
    }

    public boolean inRange(int n) {
        return this.min <= n && n <= this.max;
    }

    @Override
    public IntegerInRange getSerializableObject(String s) {
        return new IntegerInRange(s);
    }

    @Override
    public String getSerializableString() {
        return (this.min == Integer.MIN_VALUE ? "" : Integer.valueOf(this.min)) + ".." + (this.max == Integer.MAX_VALUE ? "" : Integer.valueOf(this.max));
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public String toString() {
        return "IntegerInRange{min=" + this.min + ", max=" + this.max + '}';
    }
}

