/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.telegram_bot_api;

import java.util.ArrayList;
import org.telegram.telegrambots.meta.TelegramBotsApi;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.BotSession;
import org.telegram.telegrambots.meta.generics.LongPollingBot;
import org.telegram.telegrambots.updatesreceivers.DefaultBotSession;
import wf.utils.telegram_bot_api.models.BotDataHandler;
import wf.utils.telegram_bot_api.models.MessageHandler;
import wf.utils.telegram_bot_api.models.Sender;

public class TelegramBot {
    private static final TelegramBotsApi api;
    private final BotSession botSession;
    private final Sender sender;
    private boolean autoRestartOnFail;
    private ArrayList<MessageHandler> messageHandlers = new ArrayList();
    private boolean stopped = false;

    public TelegramBot(String botUsername, String botToken) {
        this(botUsername, botToken, true);
    }

    public TelegramBot(String botUsername, String botToken, boolean autoRestartOnFail) {
        this.sender = new BotDataHandler(botUsername, botToken, this::update, this::closing);
        this.botSession = api.registerBot((LongPollingBot)this.sender);
        this.autoRestartOnFail = autoRestartOnFail;
    }

    public void stop() {
        this.stopped = true;
        if (this.botSession.isRunning()) {
            this.botSession.stop();
        }
    }

    public void start() {
        this.stopped = false;
        if (!this.botSession.isRunning()) {
            this.botSession.start();
        }
    }

    private void closing() {
        if (!this.autoRestartOnFail && this.stopped) {
            return;
        }
        Thread.sleep(5000L);
        if (!this.autoRestartOnFail && this.stopped && !this.botSession.isRunning()) {
            this.botSession.start();
        }
    }

    public boolean isRunning() {
        return this.botSession.isRunning();
    }

    private void update(Update update) {
        this.messageHandlers.forEach(h -> h.onUpdate(update, this.sender));
        if (update.hasCallbackQuery()) {
            this.messageHandlers.forEach(h -> h.onCallbackQuery(update.getCallbackQuery(), update.getCallbackQuery().getMessage().getChatId(), update.getCallbackQuery().getMessage(), this.sender, update));
        }
        if (!update.hasMessage()) {
            return;
        }
        Message message = update.getMessage();
        if (message.hasText()) {
            this.messageHandlers.forEach(h -> h.onTextMessage(message.getText(), message.getChatId(), message, this.sender, update));
        }
    }

    public boolean addHandler(MessageHandler messageHandler) {
        return this.messageHandlers.add(messageHandler);
    }

    public boolean removeHandler(MessageHandler messageHandler) {
        return this.messageHandlers.remove(messageHandler);
    }

    public void setAutoRestartOnFail(boolean autoRestartOnFail) {
        this.autoRestartOnFail = autoRestartOnFail;
    }

    public BotSession getBotSession() {
        return this.botSession;
    }

    public Sender getSender() {
        return this.sender;
    }

    public boolean isAutoRestartOnFail() {
        return this.autoRestartOnFail;
    }

    public ArrayList<MessageHandler> getMessageHandlers() {
        return this.messageHandlers;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setMessageHandlers(ArrayList<MessageHandler> messageHandlers) {
        this.messageHandlers = messageHandlers;
    }

    static {
        try {
            api = new TelegramBotsApi(DefaultBotSession.class);
        }
        catch (TelegramApiException e) {
            throw new RuntimeException(e);
        }
    }
}

