/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.telegram_bot_api.models;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.DeleteMessage;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.EditMessageText;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import wf.utils.telegram_bot_api.models.Sender;

public class BotDataHandler
extends Sender {
    private final String botUsername;
    private Consumer<Update> updateHandler;
    private Runnable closingHandler;

    public BotDataHandler(String botUsername, String botToken, Consumer<Update> updateHandler, Runnable closingHandler) {
        super(botToken);
        this.botUsername = botUsername;
        this.updateHandler = updateHandler;
        this.closingHandler = closingHandler;
    }

    public void onUpdateReceived(Update update) {
        this.updateHandler.accept(update);
    }

    public void onClosing() {
        this.closingHandler.run();
    }

    public String getBotUsername() {
        return this.botUsername;
    }

    @Override
    public Message sendMessage(Long chatId, String text) {
        SendMessage message = new SendMessage();
        message.setChatId(chatId);
        message.setText(text);
        return (Message)this.execute((BotApiMethod)message);
    }

    @Override
    public CompletableFuture<Message> sendMessageAsync(Long chatId, String text) {
        SendMessage message = new SendMessage();
        message.setChatId(chatId);
        message.setText(text);
        return this.executeAsync((BotApiMethod)message);
    }

    @Override
    public Message sendMessageReply(Long chatId, int replyId, String text) {
        SendMessage message = new SendMessage();
        message.setChatId(chatId);
        message.setReplyToMessageId(Integer.valueOf(replyId));
        message.setText(text);
        return (Message)this.execute((BotApiMethod)message);
    }

    @Override
    public CompletableFuture<Message> sendMessageReplyAsync(Long chatId, int replyId, String text) {
        SendMessage message = new SendMessage();
        message.setChatId(chatId);
        message.setReplyToMessageId(Integer.valueOf(replyId));
        message.setText(text);
        return this.executeAsync((BotApiMethod)message);
    }

    @Override
    public Message editMessage(Long chatId, int messageId, String newText) {
        EditMessageText editMessage = new EditMessageText();
        editMessage.setChatId(chatId);
        editMessage.setMessageId(Integer.valueOf(messageId));
        editMessage.setText(newText);
        return (Message)this.execute((BotApiMethod)editMessage);
    }

    @Override
    public CompletableFuture<Serializable> editMessageAsync(Long chatId, int messageId, String newText) {
        EditMessageText editMessage = new EditMessageText();
        editMessage.setChatId(chatId);
        editMessage.setMessageId(Integer.valueOf(messageId));
        editMessage.setText(newText);
        return this.executeAsync((BotApiMethod)editMessage);
    }

    @Override
    public Boolean deleteMessage(Long chatId, int messageId) {
        DeleteMessage deleteMessage = new DeleteMessage();
        deleteMessage.setChatId(chatId);
        deleteMessage.setMessageId(Integer.valueOf(messageId));
        return (Boolean)this.execute((BotApiMethod)deleteMessage);
    }

    @Override
    public CompletableFuture<Boolean> deleteMessageAsync(Long chatId, int messageId) {
        DeleteMessage deleteMessage = new DeleteMessage();
        deleteMessage.setChatId(chatId);
        deleteMessage.setMessageId(Integer.valueOf(messageId));
        return this.executeAsync((BotApiMethod)deleteMessage);
    }
}

