/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.telegram_bot_api.spring;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.telegram.telegrambots.meta.api.objects.CallbackQuery;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import wf.utils.telegram_bot_api.TelegramBot;
import wf.utils.telegram_bot_api.models.MessageHandler;
import wf.utils.telegram_bot_api.models.Sender;
import wf.utils.telegram_bot_api.spring.annotation.TelegramBotCallbackQueryHandler;
import wf.utils.telegram_bot_api.spring.annotation.TelegramBotController;
import wf.utils.telegram_bot_api.spring.annotation.TelegramBotMessageHandler;
import wf.utils.telegram_bot_api.spring.annotation.TelegramBotTextMessageHandler;

public class TelegramBotMessageHandlerBeanPostProcessor
implements BeanPostProcessor {
    private final TelegramBot telegramBot;
    private final ArrayList<Handler> messageHandlers = new ArrayList();
    private final ArrayList<Handler> textMessageHandlers = new ArrayList();
    private final ArrayList<Handler> callbackQueryHandlers = new ArrayList();

    public TelegramBotMessageHandlerBeanPostProcessor(TelegramBot telegramBot) {
        this.telegramBot = telegramBot;
        telegramBot.addHandler(new MessageHandler(){

            @Override
            public void onTextMessage(String text, Long chatId, Message message, Sender sender, Update update) {
                for (Handler h : TelegramBotMessageHandlerBeanPostProcessor.this.textMessageHandlers) {
                    TelegramBotMessageHandlerBeanPostProcessor.invoke(h, new Object[]{text, chatId, message, sender, update});
                }
            }

            @Override
            public void onUpdate(Update update, Sender sender) {
                for (Handler h : TelegramBotMessageHandlerBeanPostProcessor.this.messageHandlers) {
                    TelegramBotMessageHandlerBeanPostProcessor.invoke(h, new Object[]{update, sender});
                }
            }

            @Override
            public void onCallbackQuery(CallbackQuery callbackQuery, Long chatId, Message message, Sender sender, Update update) {
                for (Handler h : TelegramBotMessageHandlerBeanPostProcessor.this.callbackQueryHandlers) {
                    TelegramBotMessageHandlerBeanPostProcessor.invoke(h, new Object[]{callbackQuery, chatId, message, sender, update});
                }
            }
        });
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = bean.getClass();
        if (beanClass.isAnnotationPresent(TelegramBotController.class)) {
            Method[] methods;
            for (Method method : methods = beanClass.getDeclaredMethods()) {
                if (method.isAnnotationPresent(TelegramBotMessageHandler.class)) {
                    this.messageHandlers.add(new Handler(bean, method));
                }
                if (method.isAnnotationPresent(TelegramBotTextMessageHandler.class)) {
                    this.textMessageHandlers.add(new Handler(bean, method));
                }
                if (!method.isAnnotationPresent(TelegramBotCallbackQueryHandler.class)) continue;
                this.callbackQueryHandlers.add(new Handler(bean, method));
            }
        }
        return bean;
    }

    private static void invoke(Handler handler, Object ... objects) {
        Class<?>[] parameterTypes = handler.getMethod().getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            args[i] = i < objects.length && parameterTypes[i].isInstance(objects[i]) ? objects[i] : null;
        }
        try {
            handler.getMethod().invoke(handler.getObj(), args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public TelegramBot getTelegramBot() {
        return this.telegramBot;
    }

    public ArrayList<Handler> getMessageHandlers() {
        return this.messageHandlers;
    }

    public ArrayList<Handler> getTextMessageHandlers() {
        return this.textMessageHandlers;
    }

    public ArrayList<Handler> getCallbackQueryHandlers() {
        return this.callbackQueryHandlers;
    }

    private static final class Handler {
        private Object obj;
        private Method method;

        public Object getObj() {
            return this.obj;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setObj(Object obj) {
            this.obj = obj;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Handler)) {
                return false;
            }
            Handler other = (Handler)o;
            Object this$obj = this.getObj();
            Object other$obj = other.getObj();
            if (this$obj == null ? other$obj != null : !this$obj.equals(other$obj)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $obj = this.getObj();
            result = result * 59 + ($obj == null ? 43 : $obj.hashCode());
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            return result;
        }

        public String toString() {
            return "TelegramBotMessageHandlerBeanPostProcessor.Handler(obj=" + this.getObj() + ", method=" + this.getMethod() + ")";
        }

        public Handler(Object obj, Method method) {
            this.obj = obj;
            this.method = method;
        }
    }
}

