/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.telegram_bot_api.models;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.ForwardMessage;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.DeleteMessage;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.EditMessageReplyMarkup;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.EditMessageText;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;

public class BotExecutor
extends TelegramLongPollingBot {
    private final String botUsername;
    private final Consumer<Update> updateHandler;
    private final Runnable closingHandler;

    public BotExecutor(String botUsername, String botToken, Consumer<Update> updateHandler, Runnable closingHandler) {
        super(botToken);
        this.botUsername = botUsername;
        this.updateHandler = updateHandler;
        this.closingHandler = closingHandler;
    }

    public void onUpdateReceived(Update update) {
        this.updateHandler.accept(update);
    }

    public void onClosing() {
        this.closingHandler.run();
    }

    public String getBotUsername() {
        return this.botUsername;
    }

    public Message sendMessage(Long chatId, String text) {
        SendMessage message = new SendMessage();
        message.setChatId(chatId);
        message.setText(text);
        return (Message)this.execute((BotApiMethod)message);
    }

    public CompletableFuture<Message> sendMessageAsync(Long chatId, String text) {
        SendMessage message = new SendMessage();
        message.setChatId(chatId);
        message.setText(text);
        return this.executeAsync((BotApiMethod)message);
    }

    public Message sendMessageReply(Long chatId, int replyId, String text) {
        SendMessage message = new SendMessage();
        message.setChatId(chatId);
        message.setReplyToMessageId(Integer.valueOf(replyId));
        message.setText(text);
        return (Message)this.execute((BotApiMethod)message);
    }

    public CompletableFuture<Message> sendMessageReplyAsync(Long chatId, int replyId, String text) {
        SendMessage message = new SendMessage();
        message.setChatId(chatId);
        message.setReplyToMessageId(Integer.valueOf(replyId));
        message.setText(text);
        return this.executeAsync((BotApiMethod)message);
    }

    public Message editMessageText(Long chatId, int messageId, String newText) {
        EditMessageText editMessage = new EditMessageText();
        editMessage.setChatId(chatId);
        editMessage.setMessageId(Integer.valueOf(messageId));
        editMessage.setText(newText);
        return (Message)this.execute((BotApiMethod)editMessage);
    }

    public CompletableFuture<Serializable> editMessageTextAsync(Long chatId, int messageId, String newText) {
        EditMessageText editMessage = new EditMessageText();
        editMessage.setChatId(chatId);
        editMessage.setMessageId(Integer.valueOf(messageId));
        editMessage.setText(newText);
        return this.executeAsync((BotApiMethod)editMessage);
    }

    public Boolean deleteMessage(Long chatId, int messageId) {
        DeleteMessage deleteMessage = new DeleteMessage();
        deleteMessage.setChatId(chatId);
        deleteMessage.setMessageId(Integer.valueOf(messageId));
        return (Boolean)this.execute((BotApiMethod)deleteMessage);
    }

    public CompletableFuture<Boolean> deleteMessageAsync(Long chatId, int messageId) {
        DeleteMessage deleteMessage = new DeleteMessage();
        deleteMessage.setChatId(chatId);
        deleteMessage.setMessageId(Integer.valueOf(messageId));
        return this.executeAsync((BotApiMethod)deleteMessage);
    }

    public Message editMessageReplyMarkup(Long chatId, int messageId, InlineKeyboardMarkup replyKeyboard) {
        EditMessageReplyMarkup editMessage = new EditMessageReplyMarkup();
        editMessage.setChatId(chatId);
        editMessage.setMessageId(Integer.valueOf(messageId));
        editMessage.setReplyMarkup(replyKeyboard);
        return (Message)this.execute((BotApiMethod)editMessage);
    }

    public CompletableFuture<Serializable> editMessageReplyMarkupAsync(Long chatId, int messageId, InlineKeyboardMarkup replyKeyboard) {
        EditMessageReplyMarkup editMessage = new EditMessageReplyMarkup();
        editMessage.setChatId(chatId);
        editMessage.setMessageId(Integer.valueOf(messageId));
        editMessage.setReplyMarkup(replyKeyboard);
        return this.executeAsync((BotApiMethod)editMessage);
    }

    public Message forwardMessage(Long chatId, Long fromChatId, int messageId) {
        ForwardMessage forwardMessage = new ForwardMessage();
        forwardMessage.setChatId(chatId);
        forwardMessage.setFromChatId(fromChatId);
        forwardMessage.setMessageId(Integer.valueOf(messageId));
        return (Message)this.execute((BotApiMethod)forwardMessage);
    }

    public CompletableFuture<Message> forwardMessageAsync(Long chatId, Long fromChatId, int messageId) {
        ForwardMessage forwardMessage = new ForwardMessage();
        forwardMessage.setChatId(chatId);
        forwardMessage.setFromChatId(fromChatId);
        forwardMessage.setMessageId(Integer.valueOf(messageId));
        return this.executeAsync((BotApiMethod)forwardMessage);
    }
}

