/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.command.handler.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import wf.utils.bukkit.command.handler.subcommand.SubCommand;
import wf.utils.bukkit.command.handler.subcommand.SubCommandBuilder;
import wf.utils.bukkit.command.handler.subcommand.executor.Argument;
import wf.utils.bukkit.command.handler.subcommand.executor.types.bukkit.BukkitArgumentType;
import wf.utils.bukkit.config.language.GeneralLanguage;
import wf.utils.bukkit.config.language.PersonalLanguage;
import wf.utils.bukkit.config.language.models.Language;
import wf.utils.bukkit.config.language.models.LanguageType;
import wf.utils.bukkit.config.language.models.MessageReceiver;

public class CommandHandler
implements CommandExecutor,
TabExecutor {
    private JavaPlugin plugin;
    private String ownCommandName;
    private TreeMap<String, SubCommand> subcommands = new TreeMap((str1, str2) -> str1.compareTo((String)str2) * -1);
    private Language language;
    private LanguageType languageType;

    public CommandHandler(JavaPlugin plugin, String[] commands, Language language, boolean addDefaultCommands) {
        this.plugin = plugin;
        this.language = language;
        this.languageType = LanguageType.getLanguageType(language);
        this.ownCommandName = commands[0];
        for (String command : commands) {
            plugin.getCommand(command).setExecutor((CommandExecutor)this);
            plugin.getCommand(command).setTabCompleter((TabCompleter)this);
        }
        if (addDefaultCommands) {
            this.addDefaultCommands();
        }
    }

    public CommandHandler(JavaPlugin plugin, String[] commands, Language language) {
        this(plugin, commands, language, true);
    }

    public CommandHandler(JavaPlugin plugin, String command, Language language) {
        this.plugin = plugin;
        this.language = language;
        this.languageType = LanguageType.getLanguageType(language);
        plugin.getCommand(command).setExecutor((CommandExecutor)this);
        plugin.getCommand(command).setTabCompleter((TabCompleter)this);
        this.ownCommandName = command;
        this.addDefaultCommands();
    }

    public CommandHandler(JavaPlugin plugin, String[] commands) {
        this(plugin, commands, null, true);
    }

    public CommandHandler(JavaPlugin plugin, String command) {
        this.plugin = plugin;
        plugin.getCommand(command).setExecutor((CommandExecutor)this);
        plugin.getCommand(command).setTabCompleter((TabCompleter)this);
        this.ownCommandName = command;
        this.addDefaultCommands();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(ChatColor.GOLD + "/" + this.ownCommandName + ChatColor.AQUA + " <" + ChatColor.DARK_GREEN + String.join((CharSequence)(ChatColor.RED + ", " + ChatColor.DARK_GREEN), this.subcommands.keySet().stream().map(s -> s.split("\\.")[0]).distinct().collect(Collectors.toList())) + ChatColor.AQUA + ">");
            return true;
        }
        MessageReceiver msg = this.getMessageReceiver(sender.getName());
        for (Map.Entry<String, SubCommand> entry : this.subcommands.entrySet()) {
            CharSequence[] subcommandArgs = entry.getKey().split("\\.");
            String full = String.join((CharSequence)".", Arrays.copyOfRange(args, 0, subcommandArgs.length));
            if (!full.equalsIgnoreCase(String.join((CharSequence)".", subcommandArgs))) continue;
            entry.getValue().onCommand(sender, command, args, subcommandArgs.length, msg);
            return true;
        }
        if (msg == null) {
            sender.sendMessage("\n" + ChatColor.RED + "Command not found!");
        } else {
            sender.sendMessage(ChatColor.RED + msg.get("COMMAND.DEFAULT.COMMAND_NOT_FOUND"));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return null;
        }
        ArrayList<String> tabulation = new ArrayList<String>();
        for (Map.Entry<String, SubCommand> entry : this.subcommands.entrySet()) {
            if (!entry.getValue().checkPermission(sender)) continue;
            String[] subcommandArgs = entry.getKey().split("\\.");
            if (args.length < 2) {
                tabulation.add(subcommandArgs[0]);
                continue;
            }
            boolean isIt = true;
            int max = Math.min(args.length - 1, subcommandArgs.length);
            for (int i = 0; i < max; ++i) {
                if (subcommandArgs[i].equalsIgnoreCase(args[i])) continue;
                isIt = false;
                break;
            }
            if (!isIt) continue;
            if (args.length <= subcommandArgs.length) {
                tabulation.add(subcommandArgs[args.length - 1]);
                continue;
            }
            if (args.length > subcommandArgs.length + entry.getValue().getSubCommandExecutor().getArguments().length) continue;
            return entry.getValue().getSubCommandExecutor().getArguments()[args.length - subcommandArgs.length - 1].getType().tabulation((CommandSender)((Player)sender), args[args.length - 1]);
        }
        return tabulation;
    }

    public void addDefaultCommands() {
        this.addSubcommand(new SubCommandBuilder().setCommand("allcommands").setRunnable((sender, command, args) -> {
            int availableCommandsCount = 0;
            for (Map.Entry<String, SubCommand> entry : this.subcommands.entrySet()) {
                if (!entry.getValue().checkPermission((CommandSender)sender)) continue;
                if (availableCommandsCount == 0) {
                    sender.sendMessage("\n");
                }
                sender.sendMessage(entry.getValue().getSubCommandExecutor().getArgumentsText());
                ++availableCommandsCount;
            }
            if (availableCommandsCount == 0) {
                if (this.language == null) {
                    sender.sendMessage("Not found available commands!");
                } else {
                    sender.sendMessage(this.getMess((CommandSender)sender, "COMMAND.DEFAULT.NOT_FOUND_AVAILABLE_COMMANDS"));
                }
            }
        }).build());
        if (this.language != null && this.language.getAvailableLanguages().size() > 1) {
            if (this.languageType == LanguageType.GENERAL) {
                this.addSubcommand(new SubCommandBuilder().setCommand("language").setPermission("wf.language.change").setArguments(new Argument(BukkitArgumentType.LANGUAGE(this.language))).setRunnable((sender, command, args) -> {
                    ((GeneralLanguage)this.language).selectLanguage((Plugin)this.plugin, (String)args[0]);
                    sender.sendMessage(ChatColor.YELLOW + this.getMess((CommandSender)sender, "COMMAND.DEFAULT.LANGUAGE_CHANGE").replace("%{lang}", ChatColor.AQUA + (String)args[0]));
                }).build());
            } else if (this.languageType == LanguageType.PERSONAL) {
                this.addSubcommand(new SubCommandBuilder().setCommand("language").setArguments(new Argument(BukkitArgumentType.LANGUAGE(this.language))).setRunnable((sender, command, args) -> {
                    ((PersonalLanguage)this.language).setPlayerLanguage(sender.getName(), (String)args[0]);
                    sender.sendMessage(ChatColor.YELLOW + this.getMess((CommandSender)sender, "COMMAND.DEFAULT.LANGUAGE_CHANGE").replace("%{lang}", ChatColor.AQUA + (String)args[0]));
                }).build());
            }
        }
    }

    public void addSubcommand(String command, SubCommand subcommand) {
        subcommand.getSubCommandExecutor().setCommand("/" + this.ownCommandName + " " + String.join((CharSequence)" ", command.split("\\.")));
        this.subcommands.put(command, subcommand);
    }

    public void addSubcommand(SubCommand subcommand) {
        subcommand.getSubCommandExecutor().setCommand("/" + this.ownCommandName + " " + String.join((CharSequence)" ", subcommand.getCommand().split("\\.")));
        this.subcommands.put(subcommand.getCommand(), subcommand);
    }

    public MessageReceiver getMessageReceiver(String player) {
        if (this.language == null) {
            return null;
        }
        if (this.languageType == LanguageType.PERSONAL) {
            return ((PersonalLanguage)this.language).getMessageReceiver(player);
        }
        if (this.languageType == LanguageType.GENERAL) {
            return ((GeneralLanguage)this.language).getMessageReceiver();
        }
        return null;
    }

    public String getMess(CommandSender sender, String path) {
        if (this.language == null) {
            return null;
        }
        if (this.languageType == LanguageType.GENERAL) {
            return ((GeneralLanguage)this.language).mess(path);
        }
        if (this.languageType == LanguageType.PERSONAL) {
            return ((PersonalLanguage)this.language).getMessageReceiver(sender.getName()).get(path);
        }
        return path;
    }

    public TreeMap<String, SubCommand> getSubcommands() {
        return this.subcommands;
    }

    public void setSubcommands(TreeMap<String, SubCommand> subcommands) {
        this.subcommands = subcommands;
    }

    public String getOwnCommandName() {
        return this.ownCommandName;
    }

    public void setOwnCommandName(String ownCommandName) {
        this.ownCommandName = ownCommandName;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String toString() {
        return "CommandHandler{plugin=" + this.plugin + ", ownCommandName='" + this.ownCommandName + "', subcommands=" + this.subcommands + ", language=" + this.language + "}";
    }
}

