/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.command.handler.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import wf.utils.bukkit.command.handler.DefaultCommandHandlerMessages;
import wf.utils.bukkit.command.handler.handler.CommandHandler;
import wf.utils.bukkit.config.language.GeneralLanguage;
import wf.utils.bukkit.config.language.PersonalLanguage;
import wf.utils.bukkit.config.language.models.Language;
import wf.utils.bukkit.config.language.models.LanguageType;
import wf.utils.java.file.yamlconfiguration.configuration.ConfigDefaultValue;

public class CommandHandlerBuilder {
    private JavaPlugin plugin;
    private ArrayList<String> commands = new ArrayList();
    private ArrayList<String> defaultLanguages = new ArrayList();
    private boolean autoAddDefaultCommands = true;
    private String languagePath;
    private LanguageType languageType = LanguageType.GENERAL;
    private Collection<ConfigDefaultValue> values;

    public CommandHandlerBuilder setPlugin(JavaPlugin plugin) {
        this.plugin = plugin;
        return this;
    }

    public CommandHandlerBuilder setCommands(String ... command) {
        if (!this.commands.isEmpty()) {
            this.commands.clear();
        }
        for (String s : command) {
            this.commands.add(s);
        }
        return this;
    }

    public CommandHandlerBuilder setDefaultLanguages(String ... language) {
        if (!this.defaultLanguages.isEmpty()) {
            this.defaultLanguages.clear();
        }
        for (String s : language) {
            this.defaultLanguages.add(s);
        }
        return this;
    }

    public CommandHandlerBuilder setAutoAddDefaultCommands(boolean autoAddDefaultCommands) {
        this.autoAddDefaultCommands = autoAddDefaultCommands;
        return this;
    }

    public CommandHandlerBuilder setLanguagePath(String languagePath) {
        this.languagePath = languagePath;
        return this;
    }

    public CommandHandlerBuilder setLanguageType(LanguageType languageType) {
        this.languageType = languageType;
        return this;
    }

    public CommandHandlerBuilder setValues(Collection<ConfigDefaultValue> values) {
        this.values = values;
        return this;
    }

    public CommandHandlerBuilder setDefaultValues(ConfigDefaultValue ... configDefaultValues) {
        this.values = Arrays.asList(configDefaultValues);
        return this;
    }

    private Language createLanguage() {
        if (this.languagePath == null) {
            return null;
        }
        if (this.languageType == LanguageType.GENERAL) {
            return new GeneralLanguage((Plugin)this.plugin, this.languagePath, this.defaultLanguages.toArray(new String[0]), this.getValues());
        }
        if (this.languageType == LanguageType.PERSONAL) {
            return new PersonalLanguage((Plugin)this.plugin, this.languagePath, this.defaultLanguages.toArray(new String[0]), this.getValues());
        }
        return null;
    }

    private Collection<ConfigDefaultValue> getValues() {
        if (this.values == null) {
            return DefaultCommandHandlerMessages.getInstance().getValues();
        }
        return CommandHandlerBuilder.concatenateValues(DefaultCommandHandlerMessages.getInstance().getValues(), this.values);
    }

    private static Collection<ConfigDefaultValue> concatenateValues(Collection<ConfigDefaultValue> a, Collection<ConfigDefaultValue> b) {
        a.addAll(b);
        return a.stream().distinct().collect(Collectors.toList());
    }

    public CommandHandler build() {
        return new CommandHandler(this.plugin, this.commands.toArray(new String[0]), this.createLanguage(), this.autoAddDefaultCommands);
    }
}

