/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.command.handler.subcommand.executor;

import org.bukkit.command.CommandSender;
import wf.utils.bukkit.command.handler.subcommand.executor.types.ArgumentType;

public class Argument {
    private String name = null;
    private ArgumentType type = ArgumentType.STRING;
    private Object def;
    private boolean obligatorily = true;

    public Argument(String name) {
        this.name = name;
    }

    public Argument(String name, ArgumentType type) {
        this.name = name;
        this.type = type;
    }

    public Argument(String name, ArgumentType type, boolean obl) {
        this.name = name;
        this.type = type;
        this.obligatorily = obl;
    }

    public Argument(String name, ArgumentType type, Object def) {
        this.name = name;
        this.type = type;
        this.def = def;
    }

    public Argument(String name, ArgumentType type, boolean obl, Object def) {
        this.name = name;
        this.type = type;
        this.def = def;
        this.obligatorily = obl;
    }

    public Argument(ArgumentType type, boolean obl, Object def) {
        this.type = type;
        this.def = def;
        this.obligatorily = obl;
    }

    public Argument(ArgumentType type, Object def) {
        this.type = type;
        this.def = def;
    }

    public Argument(ArgumentType type) {
        this.type = type;
    }

    public boolean typeIsRight(CommandSender sender, String argument) {
        return this.type.isIt(sender, argument);
    }

    public Object get(CommandSender sender, String argument) {
        return this.type.get(sender, argument);
    }

    public String getName() {
        if (this.name == null) {
            if (this.type.getName() == null) {
                return "arg";
            }
            return this.type.getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArgumentType getType() {
        return this.type;
    }

    public void setType(ArgumentType type) {
        this.type = type;
    }

    public boolean isObligatorily() {
        return this.obligatorily;
    }

    public Object getDefault() {
        return this.def;
    }

    public void setDefault(Object def) {
        this.def = def;
    }

    public String toString() {
        return "Argument{name='" + this.name + "', type=" + this.type + ", def=" + this.def + ", obligatorily=" + this.obligatorily + "}";
    }
}

