/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.command.handler.subcommand.executor;

import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import wf.utils.bukkit.command.handler.subcommand.executor.Argument;
import wf.utils.bukkit.config.language.models.MessageReceiver;

public class SubCommandExecutor {
    private Argument[] arguments;
    private String command = "/command";

    public SubCommandExecutor(Argument ... arguments) {
        this.arguments = arguments;
    }

    public SubCommandExecutor() {
        this.arguments = new Argument[0];
    }

    public SubCommandExecutor(String command, Argument ... arguments) {
        this.command = command;
        this.arguments = arguments;
    }

    public Object[] calculate(CommandSender sender, MessageReceiver messages, String[] args, int argsOffSet) {
        return this.calculate(sender, messages, argsOffSet == 0 ? args : Arrays.copyOfRange(args, argsOffSet, args.length));
    }

    public Object[] calculate(CommandSender sender, MessageReceiver messages, String[] args) {
        if (this.getMinObligatorilyArgs() > args.length) {
            sender.sendMessage("\n" + ChatColor.RED + (messages == null ? "Write all arguments!" : messages.get("COMMAND.DEFAULT.WRITE_ALL_ARGUMENTS")));
            sender.sendMessage(this.getArgumentsText());
            return null;
        }
        Object[] objects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            Argument argument = this.arguments[i];
            if (args.length > i) {
                if (!argument.typeIsRight(sender, args[i])) {
                    sender.sendMessage(ChatColor.RED + "\n" + (messages == null || argument.getType().getMessageCode() == null ? argument.getType().getMessage() : messages.get(argument.getType().getMessageCode())));
                    sender.sendMessage(this.getWrongArgumentText(i));
                    return null;
                }
                objects[i] = argument.get(sender, args[i]);
                continue;
            }
            objects[i] = argument.getDefault();
        }
        return objects;
    }

    public String getWrongArgumentText(int num) {
        StringBuilder builder = new StringBuilder(ChatColor.GOLD + this.command);
        for (int i = 0; i < this.arguments.length; ++i) {
            builder.append(" " + ChatColor.AQUA + "{").append(i == num ? ChatColor.DARK_RED : (i > num ? ChatColor.YELLOW : ChatColor.GREEN)).append(!this.arguments[i].isObligatorily() ? "@" : "").append(this.arguments[i].getName()).append(ChatColor.AQUA).append("}");
        }
        return builder.toString();
    }

    public String getArgumentsText() {
        StringBuilder text = new StringBuilder(ChatColor.GOLD + this.command);
        for (Argument argument : this.arguments) {
            text.append(ChatColor.AQUA + " {" + ChatColor.RED).append(!argument.isObligatorily() ? "@" : "").append(argument.getName()).append(ChatColor.AQUA).append("}");
        }
        return text.toString();
    }

    public int getMinObligatorilyArgs() {
        return SubCommandExecutor.getMinObligatorilyArgs(this.arguments);
    }

    public static int getMinObligatorilyArgs(Argument[] arguments) {
        int min = 0;
        for (int i = 0; i < arguments.length && arguments[i].isObligatorily(); ++i) {
            min = i + 1;
        }
        return min;
    }

    public Argument[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Argument[] arguments) {
        this.arguments = arguments;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String toString() {
        return "CommandBuilder{arguments=" + Arrays.toString(this.arguments) + ", command='" + this.command + "'}";
    }
}

