/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.command.handler.subcommand.executor.types.bukkit;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import wf.utils.bukkit.command.handler.subcommand.executor.types.ArgumentType;

public class ConfigurationArgument
implements ArgumentType {
    private Configuration configuration;
    private String path;

    public ConfigurationArgument(Configuration configuration, String path) {
        this.configuration = configuration;
        this.path = path;
    }

    public ConfigurationArgument(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String getMessage() {
        return "This argument is not valid, enter valid name!";
    }

    @Override
    public String getMessageCode() {
        return "COMMAND.DEFAULT.ARGUMENT.CONFIGURATION_SECTION_ARGUMENT_WRONG";
    }

    @Override
    public String getName() {
        return "configuration_section";
    }

    @Override
    public boolean isIt(CommandSender sender, String argument) {
        if (this.path == null) {
            return this.configuration.contains(argument);
        }
        return this.configuration.contains(this.path + "." + argument);
    }

    @Override
    public Object get(CommandSender sender, String argument) {
        return argument;
    }

    @Override
    public List<String> tabulation(CommandSender sender, String arg) {
        if (this.path == null) {
            return new ArrayList<String>(this.configuration.getKeys(false));
        }
        return new ArrayList<String>(this.configuration.getConfigurationSection(this.path).getKeys(false));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

