/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.command.handler.subcommand.executor.types.bukkit;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import wf.utils.bukkit.command.handler.subcommand.executor.types.ArgumentType;

public class ItemArgument
implements ArgumentType {
    @Override
    public String getMessage() {
        return "This argument is not valid, enter minecraft item name!";
    }

    @Override
    public String getMessageCode() {
        return "COMMAND.DEFAULT.ARGUMENT.ITEM_ARGUMENT_WRONG";
    }

    @Override
    public String getName() {
        return "item";
    }

    @Override
    public boolean isIt(CommandSender sender, String argument) {
        return Material.getMaterial((String)argument.toUpperCase()) != null;
    }

    @Override
    public Object get(CommandSender sender, String argument) {
        return Material.getMaterial((String)argument.toUpperCase());
    }

    @Override
    public List<String> tabulation(CommandSender sender, String arg) {
        return this.getContainedMaterials(arg);
    }

    private List<String> getAllMaterials() {
        ArrayList<String> list = new ArrayList<String>();
        for (Material mat : Material.values()) {
            if (!mat.isItem()) continue;
            list.add(mat.name().toLowerCase());
        }
        return list;
    }

    private List<String> getContainedMaterials(String material) {
        if (material.isEmpty()) {
            return this.getAllMaterials();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String mat : this.getAllMaterials()) {
            if (!mat.contains(material.toLowerCase())) continue;
            list.add(mat);
        }
        return list;
    }
}

