/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.command.handler.subcommand.executor.types.bukkit;

import java.util.List;
import org.bukkit.command.CommandSender;
import wf.utils.bukkit.command.handler.subcommand.executor.types.ArgumentType;
import wf.utils.bukkit.config.language.models.Language;

public class LanguageArgument
implements ArgumentType {
    private Language language;

    public LanguageArgument(Language language) {
        this.language = language;
    }

    @Override
    public String getMessage() {
        return "This argument is not valid, enter available language!";
    }

    @Override
    public String getMessageCode() {
        return "COMMAND.DEFAULT.ARGUMENT.LANGUAGE_ARGUMENT_WRONG";
    }

    @Override
    public String getName() {
        return "language";
    }

    @Override
    public boolean isIt(CommandSender sender, String argument) {
        for (String language : this.language.getAvailableLanguages()) {
            if (!language.equalsIgnoreCase(argument)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(CommandSender sender, String argument) {
        for (String language : this.language.getAvailableLanguages()) {
            if (!language.equalsIgnoreCase(argument)) continue;
            return language;
        }
        return argument;
    }

    @Override
    public List<String> tabulation(CommandSender sender, String arg) {
        return this.language.getAvailableLanguages();
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }
}

