/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.FileConfigurationOptions;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import wf.utils.bukkit.config.utils.ConfigSerializable;
import wf.utils.bukkit.misc.while_runnable.BukkitMultipleLoopTask;
import wf.utils.java.file.yamlconfiguration.configuration.ConfigDefaultValue;
import wf.utils.java.file.yamlconfiguration.utils.StringSerializable;
import wf.utils.java.file.yamlconfiguration.utils.types.IntegerInRange;
import wf.utils.java.file.yamlconfiguration.utils.types.IntegerRandom;
import wf.utils.java.thread.loop.MultipleLoopTask;
import wf.utils.java.thread.loop.ThreadMultipleLoopTask;

public class BukkitConfig {
    private final File file;
    private FileConfiguration config;
    private MultipleLoopTask autoSaveLoopTask;
    private static HashMap<UniquenessLoopTaskKey, MultipleLoopTask> autoSaveLoopTaskMap;

    public BukkitConfig(Plugin plugin, String configName) {
        this(plugin, configName, true);
    }

    public BukkitConfig(Plugin plugin, String configName, boolean autoCopy) {
        this.file = new File(plugin.getDataFolder(), configName + ".yml");
        if (!this.file.exists()) {
            if (autoCopy) {
                plugin.saveResource(configName + ".yml", true);
            } else {
                try {
                    new File(this.file.getParent()).mkdirs();
                    this.file.createNewFile();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public BukkitConfig(Plugin plugin, String configName, boolean autoCopy, SaveType saveType, int autoSaveSeconds, boolean autoSaveUnique) {
        this(plugin, configName, autoCopy);
        this.autoSaveInit(plugin, saveType, autoSaveSeconds, autoSaveUnique);
    }

    public BukkitConfig(Plugin plugin, String configName, boolean autoCopy, Collection<ConfigDefaultValue> defaultValues, SaveType saveType, int autoSaveSeconds, boolean autoSaveUnique) {
        this(plugin, configName, autoCopy);
        this.autoSaveInit(plugin, saveType, autoSaveSeconds, autoSaveUnique);
        if (defaultValues != null && !defaultValues.isEmpty()) {
            this.setDefaultValues(defaultValues);
            this.save();
        }
    }

    private void autoSaveInit(Plugin plugin, SaveType saveType, int seconds, boolean autoSaveUnique) {
        if (!autoSaveUnique) {
            MultipleLoopTask task;
            if (autoSaveLoopTaskMap == null) {
                autoSaveLoopTaskMap = new HashMap();
            }
            if ((task = autoSaveLoopTaskMap.get(new UniquenessLoopTaskKey(saveType, seconds))) == null) {
                task = this.createMultipleLoopTask(plugin, saveType, seconds);
                autoSaveLoopTaskMap.put(new UniquenessLoopTaskKey(saveType, seconds), task);
            }
            this.autoSaveLoopTask = task;
            this.autoSaveLoopTask.addRunnable(this.file.getAbsolutePath(), this::save);
            this.autoSaveLoopTask.start();
        } else {
            this.autoSaveLoopTask = this.createMultipleLoopTask(plugin, saveType, seconds);
            this.autoSaveLoopTask.addRunnable(this.file.getAbsolutePath(), this::save);
            this.autoSaveLoopTask.start();
        }
    }

    public void stopAutoSave() {
        if (this.autoSaveLoopTask != null) {
            this.autoSaveLoopTask.stop();
        }
    }

    public void startAutoSave() {
        if (this.autoSaveLoopTask != null) {
            this.autoSaveLoopTask.start();
        }
    }

    private MultipleLoopTask createMultipleLoopTask(Plugin plugin, SaveType saveType, int seconds) {
        if (saveType == SaveType.BUKKIT_SYNC) {
            return new BukkitMultipleLoopTask(plugin, (long)seconds * 20L, (long)seconds * 20L, true);
        }
        if (saveType == SaveType.BUKKIT_ASYNC) {
            return new BukkitMultipleLoopTask(plugin, (long)seconds * 20L, (long)seconds * 20L, false);
        }
        if (saveType == SaveType.THREAD) {
            return new ThreadMultipleLoopTask((long)seconds * 1000L, (long)seconds * 1000L);
        }
        throw new RuntimeException("Save type invalid!");
    }

    public BukkitConfig(Plugin plugin, String configName, boolean autoCopy, Collection<ConfigDefaultValue> defaultValues) {
        this(plugin, configName, autoCopy);
        if (defaultValues != null && !defaultValues.isEmpty()) {
            this.setDefaultValues(defaultValues);
            this.save();
        }
    }

    public BukkitConfig(Plugin plugin, String configName, Collection<ConfigDefaultValue> defaultValues) {
        this(plugin, configName);
        this.setDefaultValues(defaultValues);
        this.save();
    }

    public void setDefaultValues(boolean replace, Collection<ConfigDefaultValue> defaultValues) {
        for (ConfigDefaultValue value : defaultValues) {
            if (!replace && this.config.contains(value.getPath())) continue;
            this.config.set(value.getPath(), value.getValue());
        }
    }

    public void set(String path, Object value) {
        this.config.set(path, value);
    }

    public boolean contains(String path) {
        return this.config.contains(path);
    }

    public void setDefaultValues(Collection<ConfigDefaultValue> defaultValues) {
        this.setDefaultValues(false, defaultValues);
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getString(String path) {
        return this.config.getString(path);
    }

    public int getInt(String path) {
        return this.config.getInt(path);
    }

    public long getLong(String path) {
        return this.config.getLong(path);
    }

    public double getDouble(String path) {
        return this.config.getDouble(path);
    }

    public boolean getBoolean(String path) {
        return this.config.getBoolean(path);
    }

    public List<String> getStringList(String path) {
        return this.config.getStringList(path);
    }

    public List<Integer> getIntegerList(String path) {
        return this.config.getIntegerList(path);
    }

    public List<Long> getLongList(String path) {
        return this.config.getLongList(path);
    }

    public List<Double> getDoubleList(String path) {
        return this.config.getDoubleList(path);
    }

    public List<Boolean> getBooleanList(String path) {
        return this.config.getBooleanList(path);
    }

    public List<Character> getCharacterList(String path) {
        return this.config.getCharacterList(path);
    }

    public List<Byte> getByteList(String path) {
        return this.config.getByteList(path);
    }

    public List<Float> getFloatList(String path) {
        return this.config.getFloatList(path);
    }

    public Object get(String path) {
        return this.config.get(path);
    }

    public String getString(String path, String def) {
        return this.config.getString(path, def);
    }

    public int getInt(String path, int def) {
        return this.config.getInt(path, def);
    }

    public long getLong(String path, long def) {
        return this.config.getLong(path, def);
    }

    public double getDouble(String path, double def) {
        return this.config.getDouble(path, def);
    }

    public boolean getBoolean(String path, boolean def) {
        return this.config.getBoolean(path, def);
    }

    public <T> T getObject(String path, Class<T> type) {
        return (T)this.config.getObject(path, type);
    }

    public <T> T getObject(String path, Class<T> type, T def) {
        return (T)this.config.getObject(path, type, def);
    }

    public Object get(String path, Object def) {
        return this.config.get(path, def);
    }

    public void save(File file) throws IOException {
        this.config.save(file);
    }

    public void save(String file) throws IOException {
        this.config.save(file);
    }

    public String saveToString() {
        return this.config.saveToString();
    }

    public void load(File file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        this.config.load(file);
    }

    public void load(Reader reader) throws IOException, InvalidConfigurationException {
        this.config.load(reader);
    }

    public void load(String file) throws FileNotFoundException, IOException, InvalidConfigurationException {
        this.config.load(file);
    }

    public void loadFromString(String contents) throws InvalidConfigurationException {
        this.config.loadFromString(contents);
    }

    public FileConfigurationOptions options() {
        return this.config.options();
    }

    public void addDefault(String path, Object value) {
        this.config.addDefault(path, value);
    }

    public void addDefaults(Map<String, Object> defaults) {
        this.config.addDefaults(defaults);
    }

    public void addDefaults(Configuration defaults) {
        this.config.addDefaults(defaults);
    }

    public void setDefaults(Configuration defaults) {
        this.config.setDefaults(defaults);
    }

    public Configuration getDefaults() {
        return this.config.getDefaults();
    }

    public ConfigurationSection getParent() {
        return this.config.getParent();
    }

    public Set<String> getKeys(boolean deep) {
        return this.config.getKeys(deep);
    }

    public Map<String, Object> getValues(boolean deep) {
        return this.config.getValues(deep);
    }

    public boolean contains(String path, boolean ignoreDefault) {
        return this.config.contains(path, ignoreDefault);
    }

    public boolean isSet(String path) {
        return this.config.isSet(path);
    }

    public String getCurrentPath() {
        return this.config.getCurrentPath();
    }

    public String getName() {
        return this.config.getName();
    }

    public Configuration getRoot() {
        return this.config.getRoot();
    }

    public ConfigurationSection getDefaultSection() {
        return this.config.getDefaultSection();
    }

    public ConfigurationSection createSection(String path) {
        return this.config.createSection(path);
    }

    public ConfigurationSection createSection(String path, Map<?, ?> map) {
        return this.config.createSection(path, map);
    }

    public boolean isString(String path) {
        return this.config.isString(path);
    }

    public boolean isInt(String path) {
        return this.config.isInt(path);
    }

    public boolean isBoolean(String path) {
        return this.config.isBoolean(path);
    }

    public boolean isDouble(String path) {
        return this.config.isDouble(path);
    }

    public boolean isLong(String path) {
        return this.config.isLong(path);
    }

    public List<?> getList(String path) {
        return this.config.getList(path);
    }

    public List<?> getList(String path, List<?> def) {
        return this.config.getList(path, def);
    }

    public boolean isList(String path) {
        return this.config.isList(path);
    }

    public List<Short> getShortList(String path) {
        return this.config.getShortList(path);
    }

    public List<Map<?, ?>> getMapList(String path) {
        return this.config.getMapList(path);
    }

    public <T extends ConfigurationSerializable> T getSerializable(String path, Class<T> clazz) {
        return (T)this.config.getSerializable(path, clazz);
    }

    public <T extends ConfigurationSerializable> T getSerializable(String path, Class<T> clazz, T def) {
        return (T)this.config.getSerializable(path, clazz, def);
    }

    public Vector getVector(String path) {
        return this.config.getVector(path);
    }

    public Vector getVector(String path, Vector def) {
        return this.config.getVector(path, def);
    }

    public boolean isVector(String path) {
        return this.config.isVector(path);
    }

    public OfflinePlayer getOfflinePlayer(String path) {
        return this.config.getOfflinePlayer(path);
    }

    public OfflinePlayer getOfflinePlayer(String path, OfflinePlayer def) {
        return this.config.getOfflinePlayer(path, def);
    }

    public boolean isOfflinePlayer(String path) {
        return this.config.isOfflinePlayer(path);
    }

    public ItemStack getItemStack(String path) {
        return this.config.getItemStack(path);
    }

    public ItemStack getItemStack(String path, ItemStack def) {
        return this.config.getItemStack(path, def);
    }

    public boolean isItemStack(String path) {
        return this.config.isItemStack(path);
    }

    public Color getColor(String path) {
        return this.config.getColor(path);
    }

    public Color getColor(String path, Color def) {
        return this.config.getColor(path, def);
    }

    public boolean isColor(String path) {
        return this.config.isColor(path);
    }

    public Location getLocation(String path, Location def) {
        return this.config.getLocation(path, def);
    }

    public boolean isLocation(String path) {
        return this.config.isLocation(path);
    }

    public boolean isConfigurationSection(String path) {
        return this.config.isConfigurationSection(path);
    }

    public Location getLocation(String path) {
        return this.config.getLocation(path);
    }

    public void set(String path, StringSerializable value) {
        this.set(path, value.getSerializableString());
    }

    public <T extends StringSerializable> T get(String path, T value) {
        return value.getSerializableObject(this.getString(path));
    }

    public <T extends ConfigSerializable> T get(String path, T value) {
        return (T)((ConfigSerializable)value.getSerializableObject(path, this));
    }

    public void set(String path, ConfigSerializable value) {
        value.setSerializableObject(path, this);
    }

    public void remove(String path) {
        this.config.set(path, null);
    }

    public ConfigurationSection getConfigurationSection(String path) {
        return this.config.getConfigurationSection(path);
    }

    public void forEach(String path, Consumer<String> consumer) {
        this.forEach(path, false, consumer);
    }

    public void forEach(String path, boolean deap, Consumer<String> consumer) {
        for (String s : this.getConfigurationSection(path).getKeys(deap)) {
            consumer.accept(s);
        }
    }

    public void set(String path, IntegerRandom value) {
        this.set(path, value.getSerializableString());
    }

    public IntegerRandom getIntegerRandom(String path) {
        return new IntegerRandom().getSerializableObject(this.config.getString(path));
    }

    public void set(String path, IntegerInRange value) {
        this.set(path, value.getSerializableString());
    }

    public IntegerInRange getIntegerInRange(String path) {
        return new IntegerInRange().getSerializableObject(this.config.getString(path));
    }

    public static enum SaveType {
        BUKKIT_ASYNC,
        BUKKIT_SYNC,
        THREAD;

    }

    private static class UniquenessLoopTaskKey {
        private SaveType saveType;
        private int seconds;

        public UniquenessLoopTaskKey(SaveType saveType, int seconds) {
            this.saveType = saveType;
            this.seconds = seconds;
        }

        public SaveType getSaveType() {
            return this.saveType;
        }

        public void setSaveType(SaveType saveType) {
            this.saveType = saveType;
        }

        public int getSeconds() {
            return this.seconds;
        }

        public void setSeconds(int seconds) {
            this.seconds = seconds;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UniquenessLoopTaskKey)) {
                return false;
            }
            UniquenessLoopTaskKey that = (UniquenessLoopTaskKey)o;
            if (this.getSeconds() != that.getSeconds()) {
                return false;
            }
            return this.getSaveType() == that.getSaveType();
        }

        public int hashCode() {
            int result = this.getSaveType() != null ? this.getSaveType().hashCode() : 0;
            result = 31 * result + this.getSeconds();
            return result;
        }
    }
}

