/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.config.language;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import wf.utils.bukkit.config.BukkitConfig;
import wf.utils.bukkit.config.language.models.Language;
import wf.utils.bukkit.config.language.models.MessageReceiver;
import wf.utils.java.file.yamlconfiguration.configuration.ConfigDefaultValue;

public class GeneralLanguage
implements Language {
    private List<String> availableLanguages;
    private BukkitConfig languageConfig;
    private BukkitConfig optionsConfig;
    private String path;
    private final Collection<ConfigDefaultValue> defaultValues;
    private String selectedLanguage;
    private MessageReceiver messageReceiver;

    public GeneralLanguage(Plugin plugin, String path, Collection<ConfigDefaultValue> defaultValues) {
        this(plugin, path, new String[0], defaultValues);
    }

    public GeneralLanguage(Plugin plugin, String path) {
        this(plugin, path, new String[0], (Collection<ConfigDefaultValue>)null);
    }

    public GeneralLanguage(Plugin plugin, String path, String ... dl) {
        this(plugin, path, dl, (Collection<ConfigDefaultValue>)null);
    }

    public GeneralLanguage(Plugin plugin, String path, String[] dl, Collection<ConfigDefaultValue> defaultValues) {
        this.path = path;
        this.defaultValues = defaultValues;
        this.optionsConfig = new BukkitConfig(plugin, path + File.separator + "options", false);
        this.availableLanguages = this.copyAllConfigs(plugin, dl);
        if (this.optionsConfig.contains("general_language")) {
            String generalLanguage = this.optionsConfig.getString("general_language");
            if (this.availableLanguages.contains(generalLanguage)) {
                this.selectLanguage(plugin, generalLanguage);
            } else {
                generalLanguage = this.availableLanguages.contains("en") ? "en" : this.availableLanguages.get(0);
                this.selectLanguage(plugin, generalLanguage);
                this.optionsConfig.set("general_language", generalLanguage);
                this.optionsConfig.save();
            }
            this.selectedLanguage = generalLanguage;
        } else {
            String generalLanguage = this.availableLanguages.contains("en") ? "en" : this.availableLanguages.get(0);
            this.selectLanguage(plugin, generalLanguage);
            this.selectedLanguage = generalLanguage;
            this.optionsConfig.set("general_language", generalLanguage);
            this.optionsConfig.save();
        }
    }

    private List<String> copyAllConfigs(Plugin plugin, String[] dl) {
        ArrayList<String> files = new ArrayList<String>();
        for (String l : dl) {
            GeneralLanguage.copyFromResource(plugin, this.path + File.separator + l + ".yml");
            files.add(l);
        }
        List<String> existingFiles = GeneralLanguage.getExistingConfigs(plugin, this.path);
        if (files.isEmpty() && existingFiles.isEmpty()) {
            return Arrays.asList("en");
        }
        for (String s : existingFiles) {
            if (files.contains(s)) continue;
            files.add(s);
        }
        return files;
    }

    public static List<String> getExistingConfigs(Plugin plugin, String path) {
        ArrayList<String> fileNames = new ArrayList<String>(Arrays.asList(Objects.requireNonNull(new File(plugin.getDataFolder(), path).list())));
        fileNames.remove("options.yml");
        return fileNames.stream().map(f -> f.split("\\.")[0]).collect(Collectors.toList());
    }

    public static void copyFromResource(Plugin plugin, String path) {
        File file = new File(plugin.getDataFolder(), path);
        if (!file.exists()) {
            plugin.saveResource(path, true);
        }
    }

    public void selectLanguage(Plugin plugin, String lang) {
        this.languageConfig = new BukkitConfig(plugin, this.path + File.separator + lang, false, this.defaultValues);
        this.optionsConfig.set("general_language", lang);
        this.optionsConfig.save();
        this.selectedLanguage = lang;
        this.loadMessageReceiver();
    }

    public void loadMessageReceiver() {
        this.messageReceiver = new MessageReceiver(){

            @Override
            public String get(String path) {
                return GeneralLanguage.this.mess(path);
            }

            @Override
            public String get(String path, boolean colorTranslate) {
                return GeneralLanguage.this.mess(path, colorTranslate);
            }

            @Override
            public String get(String path, char colorChar) {
                return GeneralLanguage.this.mess(path, colorChar);
            }

            @Override
            public String getLanguage() {
                return GeneralLanguage.this.selectedLanguage;
            }
        };
    }

    public MessageReceiver getMessageReceiver() {
        return this.messageReceiver;
    }

    public String mess(String path) {
        String mess = this.languageConfig.getString(path);
        return mess == null ? ChatColor.WHITE + "Message \"" + path + "\" not found" : ChatColor.translateAlternateColorCodes((char)'&', (String)mess);
    }

    public String mess(String path, boolean colorTranslate) {
        String mess = this.languageConfig.getString(path);
        return mess == null ? ChatColor.WHITE + "Message \"" + path + "\" not found" : (colorTranslate ? ChatColor.translateAlternateColorCodes((char)'&', (String)mess) : mess);
    }

    public String mess(String path, char colorChar) {
        String mess = this.languageConfig.getString(path);
        return mess == null ? ChatColor.WHITE + "Message \"" + path + "\" not found" : ChatColor.translateAlternateColorCodes((char)colorChar, (String)mess);
    }

    @Override
    public List<String> getAvailableLanguages() {
        return this.availableLanguages;
    }

    public void setAvailableLanguages(List<String> availableLanguages) {
        this.availableLanguages = availableLanguages;
    }

    public BukkitConfig getLanguageConfig() {
        return this.languageConfig;
    }

    public void setLanguageConfig(BukkitConfig languageConfig) {
        this.languageConfig = languageConfig;
    }

    public BukkitConfig getOptionsConfig() {
        return this.optionsConfig;
    }

    public void setOptionsConfig(BukkitConfig optionsConfig) {
        this.optionsConfig = optionsConfig;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSelectedLanguage() {
        return this.selectedLanguage;
    }

    public void setSelectedLanguage(String selectedLanguage) {
        this.selectedLanguage = selectedLanguage;
    }

    public void setMessageReceiver(MessageReceiver messageReceiver) {
        this.messageReceiver = messageReceiver;
    }
}

