/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.bukkit.config.language;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import wf.utils.bukkit.config.BukkitConfig;
import wf.utils.bukkit.config.language.GeneralLanguage;
import wf.utils.bukkit.config.language.models.Language;
import wf.utils.bukkit.config.language.models.MessageReceiver;
import wf.utils.java.file.yamlconfiguration.configuration.ConfigDefaultValue;

public class PersonalLanguage
implements Language {
    private List<String> availableLanguages;
    private ArrayList<BukkitConfig> allLanguages = new ArrayList();
    private HashMap<String, MessageReceiver> allReceivers = new HashMap();
    private String path;
    private BukkitConfig optionsConfig;

    public PersonalLanguage(Plugin plugin, String path, Collection<ConfigDefaultValue> defaultValues) {
        this(plugin, path, new String[0], defaultValues);
    }

    public PersonalLanguage(Plugin plugin, String path) {
        this(plugin, path, new String[0], null);
    }

    public PersonalLanguage(Plugin plugin, String path, String[] dl) {
        this(plugin, path, dl, null);
    }

    public PersonalLanguage(Plugin plugin, String path, String[] dl, Collection<ConfigDefaultValue> defaultValues) {
        this.path = path;
        this.optionsConfig = new BukkitConfig(plugin, path + File.separator + "options", false);
        this.availableLanguages = this.copyAllConfigs(plugin, dl);
        this.loadAllLanguages(plugin, this.availableLanguages, defaultValues);
    }

    private List<String> copyAllConfigs(Plugin plugin, String[] dl) {
        ArrayList<String> files = new ArrayList<String>();
        for (String l : dl) {
            GeneralLanguage.copyFromResource(plugin, this.path + File.separator + l + ".yml");
            files.add(l);
        }
        List<String> existingFiles = GeneralLanguage.getExistingConfigs(plugin, this.path);
        if (files.isEmpty() && existingFiles.isEmpty()) {
            return Arrays.asList("en");
        }
        for (String s : existingFiles) {
            if (files.contains(s)) continue;
            files.add(s);
        }
        return files;
    }

    private void loadAllLanguages(Plugin plugin, List<String> languages, Collection<ConfigDefaultValue> defaultValues) {
        for (String lang : languages) {
            BukkitConfig config = new BukkitConfig(plugin, this.path + File.separator + lang, false, defaultValues);
            this.allLanguages.add(config);
            this.allReceivers.put(lang, PersonalLanguage.createMessageReceiver(config.getConfig(), lang));
        }
    }

    private static MessageReceiver getLastElement(MessageReceiver[] array) {
        return array[array.length - 1];
    }

    public static MessageReceiver createMessageReceiver(final FileConfiguration config, final String language) {
        return new MessageReceiver(){

            @Override
            public String get(String path) {
                String mess = config.getString(path);
                return mess == null ? ChatColor.WHITE + "Message \"" + path + "\" not found" : ChatColor.translateAlternateColorCodes((char)'&', (String)mess);
            }

            @Override
            public String get(String path, boolean colorTranslate) {
                String mess = config.getString(path);
                return mess == null ? ChatColor.WHITE + "Message \"" + path + "\" not found" : (colorTranslate ? ChatColor.translateAlternateColorCodes((char)'&', (String)mess) : mess);
            }

            @Override
            public String get(String path, char colorChar) {
                String mess = config.getString(path);
                return mess == null ? ChatColor.WHITE + "Message \"" + path + "\" not found" : ChatColor.translateAlternateColorCodes((char)colorChar, (String)mess);
            }

            @Override
            public String getLanguage() {
                return language;
            }
        };
    }

    public MessageReceiver getMessageReceiver(String player) {
        String language = this.optionsConfig.getString("players." + player + ".language");
        if (language == null) {
            return PersonalLanguage.getLastElement(this.allReceivers.values().toArray(new MessageReceiver[0]));
        }
        MessageReceiver mr = this.allReceivers.get(language);
        return mr != null ? mr : PersonalLanguage.getLastElement(this.allReceivers.values().toArray(new MessageReceiver[0]));
    }

    public void setPlayerLanguage(String player, String language) {
        this.optionsConfig.set("players." + player + ".language", language);
        this.optionsConfig.save();
    }

    @Override
    public List<String> getAvailableLanguages() {
        return this.availableLanguages;
    }

    public void setAvailableLanguages(List<String> availableLanguages) {
        this.availableLanguages = availableLanguages;
    }

    public ArrayList<BukkitConfig> getAllLanguages() {
        return this.allLanguages;
    }

    public void setAllLanguages(ArrayList<BukkitConfig> allLanguages) {
        this.allLanguages = allLanguages;
    }

    public HashMap<String, MessageReceiver> getAllReceivers() {
        return this.allReceivers;
    }

    public void setAllReceivers(HashMap<String, MessageReceiver> allReceivers) {
        this.allReceivers = allReceivers;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public BukkitConfig getOptionsConfig() {
        return this.optionsConfig;
    }

    public void setOptionsConfig(BukkitConfig optionsConfig) {
        this.optionsConfig = optionsConfig;
    }
}

